/*
 * Decompiled with CFR 0.152.
 */
package com.momiage.app.asom.logic;

import com.momiage.app.asom.common.DebugCommon;
import com.momiage.app.asom.logic.MusicTheory;
import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceTrackInfo;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicCreator {
    public static final int BASE_TICK = 24;
    public static final int NOTE_LEN_1 = 96;
    public static final int NOTE_LEN_2 = 48;
    public static final int NOTE_LEN_4 = 24;
    public static final int NOTE_LEN_8 = 12;
    public static final int NOTE_LEN_16 = 6;
    public static final int NOTE_LEN_32 = 3;
    public static final int NOTE_LEN_2_DOT = 72;
    public static final int NOTE_LEN_4_DOT = 36;
    public static final int NOTE_LEN_8_DOT = 18;
    public static final int NOTE_LEN_16_DOT = 9;
    public static final int NOTE_LEN_4_TRI = 16;
    public static final int NOTE_LEN_8_TRI = 8;

    public static List<SourceTrackInfo> create(SourceInfo sourceInfo, File file) throws InvalidMidiDataException, IOException {
        Vector<SourceTrackInfo> vector = new Vector<SourceTrackInfo>();
        int[] nArray = new int[]{96, 48, 24, 12, 6, 3};
        int n = 0;
        int n2 = 48;
        int n3 = 48;
        int n4 = 127;
        int n5 = sourceInfo.getInstNo();
        int n6 = 0;
        Sequence sequence = new Sequence(0.0f, 24);
        Track track = sequence.createTrack();
        MetaMessage metaMessage = new MetaMessage();
        int n7 = sourceInfo.getTempo();
        int n8 = 60000000 / n7;
        metaMessage.setMessage(81, new byte[]{(byte)(n8 / 65536), (byte)(n8 % 65536 / 256), (byte)(n8 % 256)}, 3);
        track.add(new MidiEvent(metaMessage, 0L));
        ShortMessage shortMessage = new ShortMessage();
        MusicCreator.debugSetMessage(shortMessage, 192, n, n5, 0, 0);
        track.add(new MidiEvent(shortMessage, 0L));
        String string = sourceInfo.getRestChar();
        boolean bl = false;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        Set<Integer> set = MusicTheory.getMajorScaleNotes(sourceInfo.getKey());
        Iterator<String> iterator = sourceInfo.getSourceBody().iterator();
        while (iterator.hasNext()) {
            n13 += n14;
            ++n15;
            n14 = 0;
            String string2 = iterator.next();
            while (n14 < string2.length()) {
                try {
                    while (string.indexOf(n10) > 0) {
                        n10 = MusicCreator.debugCharAt(string2, n14++);
                    }
                    bl = false;
                    if (string.indexOf(n10 = (int)MusicCreator.debugCharAt(string2, n14++)) > 0) {
                        DebugCommon.print("");
                        DebugCommon.print("isRest");
                        bl = true;
                        while (string.indexOf(n10) > 0) {
                            n10 = MusicCreator.debugCharAt(string2, n14++);
                        }
                    } else {
                        int n16 = n9 - n10;
                        n3 = 0 == n9 ? n2 : (n3 += (n16 %= sourceInfo.getMaxNoteRange()));
                        if (n3 > 127) {
                            n3 = 127;
                        } else if (n3 < 1) {
                            n3 = 1;
                        }
                        int n17 = (Integer)set.toArray()[0];
                        if (n16 >= sourceInfo.getScaleOutNoteRate()) {
                            while (!set.contains(n3)) {
                                DebugCommon.print("Scale In Key " + sourceInfo.getKey() + " = " + --n3);
                                if (n17 <= n3) continue;
                                n3 = n17;
                            }
                        }
                        shortMessage = new ShortMessage();
                        MusicCreator.debugSetMessage(shortMessage, 144, n, n3, n4, n6);
                        track.add(new MidiEvent(shortMessage, n6));
                        vector.add(new SourceTrackInfo(144, n6, n3, n15, n13 + n14));
                        n10 = MusicCreator.debugCharAt(string2, n14++);
                        while (string.indexOf(n10) > 0) {
                            n10 = MusicCreator.debugCharAt(string2, n14++);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                n12 = n10 % nArray.length;
                if (-1 != n11) {
                    int n18 = n11 - n12;
                    n12 = n11 + (n18 %= sourceInfo.maxLengthRange);
                    DebugCommon.print("lenIndex = " + n12);
                    if (n12 < 0) {
                        n12 = 2;
                    } else if (n12 >= nArray.length) {
                        n12 = nArray.length - 2;
                    }
                }
                n6 += nArray[n12];
                n11 = n12;
                if (!bl) {
                    shortMessage = new ShortMessage();
                    MusicCreator.debugSetMessage(shortMessage, 128, n, n3, n4, n6);
                    track.add(new MidiEvent(shortMessage, n6));
                    vector.add(new SourceTrackInfo(128, n6, n3, n15, n13 + n14));
                }
                n9 = n10;
            }
        }
        if (null != file) {
            MidiSystem.write(sequence, 0, file);
        }
        MusicTheory.getMajorScaleNotes(sourceInfo.getKey());
        return vector;
    }

    private static char debugCharAt(String string, int n) {
        char c = string.charAt(n);
        DebugCommon.print(c);
        return c;
    }

    private static void debugSetMessage(ShortMessage shortMessage, int n, int n2, int n3, int n4, int n5) throws InvalidMidiDataException {
        DebugCommon.print("");
        DebugCommon.print("data = " + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5);
        shortMessage.setMessage(n, n2, n3, n4);
    }
}

