package com.momiage.app.asom.main;

import java.io.File;
import java.util.List;

import javax.swing.SwingUtilities;

import com.momiage.app.asom.gui.SourceChaserFrame;
import com.momiage.app.asom.logic.MusicCreator;
import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceInfoReader;
import com.momiage.app.asom.logic.SourceTrackInfo;

public class ASOMLauncher {

	public static String source = "";
	public static String midifile = "";

	private static final String asomVersion = "a source of music  Version 0.0.1";
	
	public static void main(String[] args) throws Exception {

		if (1 != args.length) {
			System.err.println("usage: java -cp lib/asom.jar com.momiage.app.asom.main.ASOMLauncher SOURCEFILE");
			System.exit(-1);
		}
		
		if ("-version".equals(args[0])) {
			System.out.println(asomVersion);
			System.exit(0);
		}
		
		source = args[0];
		midifile = source + ".mid";

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SourceInfo si;
				List<SourceTrackInfo> lsti;
				try {
					si = SourceInfoReader.readSource(new File(source));
					lsti = MusicCreator.create(si, new File(
							midifile));
					SourceChaserFrame scf = new SourceChaserFrame(si,
							lsti);
					scf.setVisible(true);
				}
				catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		
	}
}
