﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;

namespace AssistRB
{
    public class DlnaItem
    {
        public string Parent { get; set; }
        public string Id { get; set; }
        public string Title { get; set; }
        public string Series { get; set; }
        public string ClassType { get; set; }
        public Int64 Size { get; set; }
        public string Date { get; set; }
    }

    public class DlnaItemList
    {
        private const string RootFolderId = "FS-Folder";

        static DlnaItemList instance = null;

        private List<DlnaItem> dlnaItem = new List<DlnaItem>();
        private Dictionary<string, string> folderDictionary = new Dictionary<string, string>();
        private List<string> invalidFolder = new List<string>();

        public delegate void ListChangedDelegate();
        public event ListChangedDelegate ListChanged;

        public static DlnaItemList GetInstance()
        {
            if (instance == null)
            {
                instance = new DlnaItemList();
                instance.InvalidateAll();
            }

            return instance;
        }

        public void InvalidateAll()
        {
            invalidFolder.Clear();
            invalidFolder.Add(RootFolderId);
        }

        public void Invalidate(string folder)
        {
            if (invalidFolder.Contains(RootFolderId))
            {
                return;
            }

            if (folder == RootFolderId)
            {
                InvalidateAll();
            }
            else
            {
                if (!invalidFolder.Contains(folder))
                {
                    invalidFolder.Add(folder);
                }
            }
        }

        public List<DlnaItem> GetList()
        {
            return this.dlnaItem;
        }

        public Dictionary<string, string> GetFolderList()
        {
            return this.folderDictionary;
        }

        public List<string> GetInvalidList()
        {
            return this.invalidFolder;
        }

        public void UpdateList(
            List<DlnaItem> newList)
        {
            this.dlnaItem = newList;

            this.invalidFolder.Clear();

            // フォルダ辞書の更新
            folderDictionary.Clear();
            folderDictionary.Add("FS-Folder", "ROOT");
            foreach (DlnaItem item in this.dlnaItem)
            {
                if (item.ClassType == "container")
                {
                    folderDictionary.Add(item.Id, item.Title);
                }
            }

            if (this.ListChanged != null)
            {
                this.ListChanged();
            }
        }
    }
}
