/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    private static final int DefaultCacheSize = 1024;
    private OutputStream out;
    private byte[] cache;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;

    private BitOutputStream() {
    }

    public BitOutputStream(OutputStream outputStream) {
        this(outputStream, 1024);
    }

    public BitOutputStream(OutputStream outputStream, int n) {
        if (outputStream == null || 4 > n || 0 != (n & 3)) {
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            if (n < 4) {
                throw new IllegalArgumentException("CacheSize must be 4 or more.");
            }
            throw new IllegalArgumentException("CacheSize must be multiple of 4.");
        }
        this.out = outputStream;
        this.cache = new byte[n];
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
    }

    @Override
    public void write(int n) throws IOException {
        this.writeBits(8, n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bitCount % 8 == 0) {
            this.flush();
            this.out.write(byArray, n, n2);
        } else {
            while (0 < n2--) {
                this.writeBits(8, byArray[n++]);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        while (8 <= this.bitCount) {
            this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
            this.bitBuffer <<= 8;
            this.bitCount -= 8;
        }
        this.out.write(this.cache, 0, this.cachePosition);
        this.cachePosition = 0;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        while (0 < this.bitCount) {
            this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
            this.bitBuffer <<= 8;
            this.bitCount -= 8;
        }
        this.out.write(this.cache, 0, this.cachePosition);
        this.cachePosition = 0;
        this.out.flush();
        this.out.close();
        this.out = null;
        this.cache = null;
        this.cachePosition = 0;
        this.bitCount = 128;
        this.bitBuffer = 0;
    }

    public void writeBit(int n) throws IOException {
        this.bitBuffer |= (n & 1) << 31 - this.bitCount;
        ++this.bitCount;
        if (32 <= this.bitCount) {
            this.writeOutBitBuffer();
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.bitBuffer |= 1 << 31 - this.bitCount;
        }
        ++this.bitCount;
        if (32 <= this.bitCount) {
            this.writeOutBitBuffer();
        }
    }

    public void writeBits(int n, int n2) throws IOException {
        while (0 < n) {
            int n3 = 32 - this.bitCount;
            if (n < n3) {
                this.bitBuffer |= (n2 & -1 >>> 32 - n) << n3 - n;
                this.bitCount += n;
                n = 0;
                continue;
            }
            this.bitBuffer |= n2 >> (n -= n3) & -1 >>> 32 - n3;
            this.writeOutBitBuffer();
        }
    }

    private void writeOutBitBuffer() throws IOException {
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 24);
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 16);
        this.cache[this.cachePosition++] = (byte)(this.bitBuffer >> 8);
        this.cache[this.cachePosition++] = (byte)this.bitBuffer;
        this.bitBuffer = 0;
        this.bitCount = 0;
        if (this.cache.length <= this.cachePosition) {
            this.out.write(this.cache);
            this.cachePosition = 0;
        }
    }
}

