/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.InputStream;

public class CachedInputStream
extends InputStream {
    private static final int DefaultCacheSize = 1024;
    private InputStream in;
    private byte[] cache;
    private int cachePosition;
    private int cacheLimit;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCachePosition;
    private int markCacheLimit;

    private CachedInputStream() {
    }

    public CachedInputStream(InputStream inputStream) {
        this(inputStream, 1024);
    }

    public CachedInputStream(InputStream inputStream, int n) {
        if (inputStream == null || 0 >= n) {
            if (inputStream == null) {
                throw new IllegalArgumentException("in must not be null.");
            }
            throw new IllegalArgumentException("cacheSize must be one or more.");
        }
        this.in = inputStream;
        this.cache = new byte[n];
        this.cachePosition = 0;
        this.cacheLimit = 0;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCachePosition = 0;
        this.markCacheLimit = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.cachePosition < this.cacheLimit) {
            return this.cache[this.cachePosition++] & 0xFF;
        }
        this.fillCache();
        if (this.cachePosition < this.cacheLimit) {
            return this.cache[this.cachePosition++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (0 < n2) {
            if (this.cacheLimit <= this.cachePosition) {
                this.fillCache();
                if (this.cacheLimit <= this.cachePosition) {
                    if (n3 != n2) break;
                    return -1;
                }
            }
            int n4 = Math.min(n2, this.cacheLimit - this.cachePosition);
            System.arraycopy(this.cache, this.cachePosition, byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.cachePosition += n4;
        }
        return n3 - n2;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = l;
        while (0L < l) {
            if (this.cacheLimit <= this.cachePosition) {
                this.fillCache();
                if (this.cacheLimit <= this.cachePosition) break;
            }
            long l3 = Math.min(l, (long)(this.cacheLimit - this.cachePosition));
            l -= l3;
            this.cachePosition += (int)l3;
        }
        return l2 - l;
    }

    @Override
    public void mark(int n) {
        n = (n -= this.cacheLimit - this.cachePosition) / this.cache.length * this.cache.length + (n % this.cache.length == 0 ? 0 : this.cache.length);
        this.in.mark(n);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markPositionIsInCache = true;
    }

    @Override
    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markPositionIsInCache = false;
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int n = 0;
        while (0 <= n && this.cacheLimit < this.cache.length) {
            n = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (0 >= n) continue;
            this.cacheLimit += n;
        }
    }
}

