/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class BinaryTreeSearch
implements LzssSearchMethod {
    private static final int UNUSED = -1;
    private static final int ROOT_NODE = -2;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private int root;
    private int[] parent;
    private int[] small;
    private int[] large;

    private BinaryTreeSearch() {
    }

    public BinaryTreeSearch(int n, int n2, int n3, byte[] byArray) {
        this.DictionarySize = n;
        this.MaxMatch = n2;
        this.Threshold = n3;
        this.TextBuffer = byArray;
        this.DictionaryLimit = this.DictionarySize;
        this.root = -1;
        this.parent = new int[this.DictionarySize];
        this.large = new int[this.DictionarySize];
        this.small = new int[this.DictionarySize];
        for (int i = 0; i < this.parent.length; ++i) {
            this.parent[i] = -1;
        }
    }

    @Override
    public void put(int n) {
        this.deleteNode(n - this.DictionarySize);
        int n2 = this.root;
        int n3 = this.root;
        byte[] byArray = this.TextBuffer;
        int n4 = n + this.MaxMatch;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        while (n3 != -1) {
            n6 = n3;
            n5 = n;
            while (byArray[n6] == byArray[n5]) {
                ++n6;
                if (n4 > ++n5) continue;
                this.replaceNode(n3, n);
                return;
            }
            n2 = n3;
            n3 = byArray[n6] < byArray[n5] ? this.large[n3 & this.DictionarySize - 1] : this.small[n3 & this.DictionarySize - 1];
        }
        if (this.root != -1) {
            this.addNode(n2, n, n5 - n);
        } else {
            this.root = n;
            int n7 = n & this.DictionarySize - 1;
            this.parent[n7] = -2;
            this.small[n7] = -1;
            this.large[n7] = -1;
        }
    }

    @Override
    public int searchAndPut(int n) {
        this.deleteNode(n - this.DictionarySize);
        int n2 = -1;
        int n3 = this.root;
        int n4 = this.root;
        int n5 = this.root;
        byte[] byArray = this.TextBuffer;
        int n6 = n + this.MaxMatch;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n5 != -1) {
            n8 = n5;
            n7 = n;
            while (byArray[n8] == byArray[n7]) {
                ++n8;
                if (n6 > ++n7) continue;
                this.replaceNode(n5, n);
                return LzssOutputStream.createSearchReturn(this.MaxMatch, n5);
            }
            n9 = n7 - n;
            if (n2 < n9) {
                n3 = n5;
                n2 = n9;
            } else if (n2 == n9 && n3 < n5) {
                n3 = n5;
            }
            n4 = n5;
            n5 = byArray[n8] < byArray[n7] ? this.large[n5 & this.DictionarySize - 1] : this.small[n5 & this.DictionarySize - 1];
        }
        if (this.root != -1) {
            this.addNode(n4, n, n9);
        } else {
            this.root = n;
            int n10 = n & this.DictionarySize - 1;
            this.parent[n10] = -2;
            this.small[n10] = -1;
            this.large[n10] = -1;
        }
        n5 = n - this.DictionarySize;
        if (this.DictionaryLimit <= n5) {
            n8 = n5;
            n7 = n;
            while (byArray[n8] == byArray[n7]) {
                ++n8;
                if (n6 > ++n7) continue;
            }
            if (n2 < (n9 = n7 - n)) {
                n3 = n5;
                n2 = n9;
            }
        }
        if (this.Threshold <= n2) {
            return LzssOutputStream.createSearchReturn(n2, n3);
        }
        return -1;
    }

    @Override
    public int search(int n, int n2) {
        int n3;
        int n4 = this.Threshold - 1;
        int n5 = n;
        int n6 = Math.max(this.DictionaryLimit, n2);
        byte[] byArray = this.TextBuffer;
        int n7 = Math.min(this.TextBuffer.length, n + this.MaxMatch);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = n - 1; n6 < n3; --n3) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n4 >= (n10 = n9 - n)) continue;
            n5 = n3;
            n4 = n10;
            if (n7 <= n9) break;
        }
        n3 = this.root;
        n6 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
        while (n3 != -1) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n9 >= n7) break;
            n10 = n9 - n;
            if (n6 <= n3) {
                if (n4 < n10) {
                    n5 = n3;
                    n4 = n10;
                } else if (n4 == n10 && n5 < n3) {
                    n5 = n3;
                }
            }
            n3 = byArray[n8] < byArray[n9] ? this.large[n3 & this.DictionarySize - 1] : this.small[n3 & this.DictionarySize - 1];
        }
        if (this.Threshold <= n4) {
            return LzssOutputStream.createSearchReturn(n4, n5);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.root -= this.DictionarySize;
        this.slideTree(this.parent);
        this.slideTree(this.small);
        this.slideTree(this.large);
    }

    @Override
    public int putRequires() {
        return this.MaxMatch;
    }

    private void addNode(int n, int n2, int n3) {
        int n4 = n & this.DictionarySize - 1;
        int n5 = n2 & this.DictionarySize - 1;
        if (this.TextBuffer[n + n3] < this.TextBuffer[n2 + n3]) {
            this.large[n4] = n2;
        } else {
            this.small[n4] = n2;
        }
        this.parent[n5] = n;
        this.small[n5] = -1;
        this.large[n5] = -1;
    }

    private void deleteNode(int n) {
        int n2 = n & this.DictionarySize - 1;
        if (this.parent[n2] != -1) {
            if (this.small[n2] == -1 && this.large[n2] == -1) {
                this.contractNode(n, -1);
            } else if (this.small[n2] == -1) {
                this.contractNode(n, this.large[n2]);
            } else if (this.large[n2] == -1) {
                this.contractNode(n, this.small[n2]);
            } else {
                int n3 = this.findNext(n);
                this.deleteNode(n3);
                this.replaceNode(n, n3);
            }
        }
    }

    private void contractNode(int n, int n2) {
        int n3 = n & this.DictionarySize - 1;
        int n4 = n2 & this.DictionarySize - 1;
        int n5 = this.parent[n3];
        int n6 = n5 & this.DictionarySize - 1;
        if (n5 != -2) {
            if (n == this.small[n6]) {
                this.small[n6] = n2;
            } else {
                this.large[n6] = n2;
            }
        } else {
            this.root = n2;
        }
        if (n2 != -1) {
            this.parent[n4] = n5;
        }
        this.parent[n3] = -1;
    }

    private void replaceNode(int n, int n2) {
        int n3 = n & this.DictionarySize - 1;
        int n4 = n2 & this.DictionarySize - 1;
        int n5 = this.parent[n3];
        int n6 = n5 & this.DictionarySize - 1;
        if (n5 != -2) {
            if (n == this.small[n6]) {
                this.small[n6] = n2;
            } else {
                this.large[n6] = n2;
            }
        } else {
            this.root = n2;
        }
        this.parent[n4] = n5;
        this.small[n4] = this.small[n3];
        this.large[n4] = this.large[n3];
        if (this.small[n4] != -1) {
            this.parent[this.small[n4] & this.DictionarySize - 1] = n2;
        }
        if (this.large[n4] != -1) {
            this.parent[this.large[n4] & this.DictionarySize - 1] = n2;
        }
        this.parent[n3] = -1;
        this.large[n3] = -1;
        this.small[n3] = -1;
    }

    private int findNext(int n) {
        int n2 = n & this.DictionarySize - 1;
        n = this.small[n2];
        n2 = n & this.DictionarySize - 1;
        while (-1 != this.large[n2]) {
            n = this.large[n2];
            n2 = n & this.DictionarySize - 1;
        }
        return n;
    }

    private void slideTree(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0 <= nArray[i] ? nArray[i] - this.DictionarySize : nArray[i];
        }
    }
}

