/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.util.zip.Checksum;

public class CRC16
implements Checksum {
    public static final int CRC_ANSY_POLY = 40961;
    public static final int CRC_ANSY_INIT = 0;
    public static final int CCITT_POLY = 33800;
    public static final int CCITT_INIT = 65535;
    public static final int DefaultPOLY = 40961;
    public static final int DefaultINIT = 0;
    private int crc;
    private int init;
    private int[] crcTable;

    public CRC16() {
        this(40961, 0);
    }

    public CRC16(int n) {
        this(n, n == 33800 ? 65535 : 0);
    }

    public CRC16(int n, int n2) {
        this(CRC16.makeCrcTable(n), n2);
    }

    public CRC16(int[] nArray, int n) {
        if (nArray.length != 256) {
            throw new IllegalArgumentException("crcTable.length must equals 256");
        }
        this.crcTable = nArray;
        this.init = n;
        this.reset();
    }

    @Override
    public void update(int n) {
        this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ n) & 0xFF];
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        while (0 < (n & 3) && 0 < n2--) {
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ byArray[n++]) & 0xFF];
        }
        while (4 <= n2) {
            int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | byArray[n++] << 24;
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ n3) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (n3 >>>= 8)) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (n3 >>>= 8)) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (n3 >>>= 8)) & 0xFF];
            n2 -= 4;
        }
        while (0 < n2--) {
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ byArray[n++]) & 0xFF];
        }
    }

    @Override
    public void reset() {
        this.crc = this.init;
    }

    @Override
    public long getValue() {
        return this.crc & 0xFFFF;
    }

    public static int[] makeCrcTable(int n) {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = i;
            for (int j = 0; j < 8; ++j) {
                if ((nArray[i] & 1) != 0) {
                    nArray[i] = nArray[i] >> 1 ^ n;
                    continue;
                }
                int n2 = i;
                nArray[n2] = nArray[n2] >> 1;
            }
        }
        return nArray;
    }
}

