/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh5Encoder
implements PostLzssEncoder {
    private BitOutputStream out;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private int DictionarySizeByteLen;
    private int position;
    private int flagBit;
    private int flagPos;
    private int currentBlock;
    private byte[][] block;
    private int[] blockSize;
    private int[][] blockCodeFreq;
    private int[][] blockOffLenFreq;
    private int[][] pattern;
    private int[][] group;

    private PostLh5Encoder() {
    }

    public PostLh5Encoder(OutputStream outputStream) {
        this(outputStream, "-lh5-");
    }

    public PostLh5Encoder(OutputStream outputStream, String string) {
        this(outputStream, string, 16384);
    }

    public PostLh5Encoder(OutputStream outputStream, String string, int n) {
        this(outputStream, string, 1, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PostLh5Encoder(OutputStream outputStream, String string, int n, int n2, int n3) {
        if (!("-lh4-".equals(string) || "-lh5-".equals(string) || "-lh6-".equals(string) || "-lh7-".equals(string))) {
            if (string != null) throw new IllegalArgumentException("Unknown compress method. " + string);
            throw new NullPointerException("method");
        }
        this.DictionarySize = CompressMethod.toDictionarySize(string);
        this.MaxMatch = CompressMethod.toMaxMatch(string);
        this.Threshold = CompressMethod.toThreshold(string);
        this.DictionarySizeByteLen = (Bits.len(this.DictionarySize - 1) + 7) / 8;
        int n4 = (this.DictionarySizeByteLen + 1) * 8 + 1;
        if (outputStream != null && 0 < n && 0 <= n3 && n3 < n && n4 <= n2) {
            this.out = outputStream instanceof BitOutputStream ? (BitOutputStream)outputStream : new BitOutputStream(outputStream);
            this.currentBlock = 0;
            this.block = new byte[n][];
            this.blockSize = new int[n];
            this.blockCodeFreq = new int[n][];
            this.blockOffLenFreq = new int[n][];
            int n5 = 256 + this.MaxMatch - this.Threshold + 1;
            int n6 = Bits.len(this.DictionarySize);
            int n7 = 0;
            while (true) {
                if (n7 >= n) {
                    this.group = PostLh5Encoder.createGroup(n, n3);
                    this.pattern = PostLh5Encoder.createPattern(n, n3);
                    this.position = 0;
                    this.flagBit = 0;
                    this.flagPos = 0;
                    return;
                }
                this.block[n7] = new byte[n2];
                this.blockCodeFreq[n7] = new int[n5];
                this.blockOffLenFreq[n7] = new int[n6];
                ++n7;
            }
        }
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("BlockNum too small. BlockNum must be 1 or more.");
        }
        if (n3 < 0) throw new IllegalArgumentException("DivideNum out of bounds( 0 to BlockNum - 1(" + (n - 1) + ") ).");
        if (n > n3) throw new IllegalArgumentException("BlockSize too small. BlockSize must be larger than " + n4);
        throw new IllegalArgumentException("DivideNum out of bounds( 0 to BlockNum - 1(" + (n - 1) + ") ).");
    }

    @Override
    public void writeCode(int n) throws IOException {
        int n2 = (256 <= n ? this.DictionarySizeByteLen + 1 : 1) + (this.flagBit == 0 ? 1 : 0);
        if (this.block[this.currentBlock].length - this.position < n2 || 65535 <= this.blockSize[this.currentBlock]) {
            ++this.currentBlock;
            if (this.block.length <= this.currentBlock) {
                this.writeOut();
            } else {
                this.position = 0;
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        } else if (this.flagBit == 0) {
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        }
        this.block[this.currentBlock][this.position++] = (byte)n;
        if (256 <= n) {
            byte[] byArray = this.block[this.currentBlock];
            int n3 = this.flagPos;
            byArray[n3] = (byte)(byArray[n3] | this.flagBit);
        }
        this.flagBit >>= 1;
        int[] nArray = this.blockCodeFreq[this.currentBlock];
        int n4 = n;
        nArray[n4] = nArray[n4] + 1;
        int n5 = this.currentBlock;
        this.blockSize[n5] = this.blockSize[n5] + 1;
    }

    @Override
    public void writeOffset(int n) {
        for (int i = this.DictionarySizeByteLen - 1 << 3; 0 <= i; i -= 8) {
            this.block[this.currentBlock][this.position++] = (byte)(n >> i);
        }
        int[] nArray = this.blockOffLenFreq[this.currentBlock];
        int n2 = Bits.len(n);
        nArray[n2] = nArray[n2] + 1;
    }

    @Override
    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.block = null;
        this.blockCodeFreq = null;
        this.blockOffLenFreq = null;
        this.group = null;
        this.pattern = null;
    }

    @Override
    public int getDictionarySize() {
        return this.DictionarySize;
    }

    @Override
    public int getMaxMatch() {
        return this.MaxMatch;
    }

    @Override
    public int getThreshold() {
        return this.Threshold;
    }

    private void writeOut() throws IOException {
        if (1 < this.block.length) {
            this.writeOutBestPattern();
        } else {
            this.writeOutGroup(new int[]{0});
            this.currentBlock = 0;
        }
        this.position = 0;
        this.flagBit = 0;
    }

    private void writeOutBestPattern() throws IOException {
        int n;
        int n2;
        int n3;
        int[] nArray = null;
        int[] nArray2 = new int[this.group.length];
        for (n3 = 0; n3 < this.group.length; ++n3) {
            if (this.group != null) {
                n2 = 0;
                for (n = 0; n < this.group[n3].length; ++n) {
                    n2 += this.blockSize[this.group[n3][n]];
                }
                if (0 < n2 && n2 < 65536) {
                    nArray2[n3] = PostLh5Encoder.calcHuffmanCodeLength(this.DictionarySize, PostLh5Encoder.margeArrays(this.group[n3], this.blockCodeFreq), PostLh5Encoder.margeArrays(this.group[n3], this.blockOffLenFreq));
                    continue;
                }
                if (0 == n2) {
                    nArray2[n3] = 0;
                    continue;
                }
                nArray2[n3] = -1;
                continue;
            }
            nArray2[n3] = -1;
        }
        n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < this.pattern.length; ++n2) {
            n = 0;
            for (int i = 0; i < this.pattern[n2].length; ++i) {
                if (0 <= nArray2[this.pattern[n2][i]]) {
                    n += nArray2[this.pattern[n2][i]];
                    continue;
                }
                n = Integer.MAX_VALUE;
                break;
            }
            if (n >= n3) continue;
            nArray = this.pattern[n2];
            n3 = n;
        }
        if (nArray != null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.writeOutGroup(this.group[nArray[n2]]);
            }
        } else {
            n2 = 0;
            while (n2 < this.block.length) {
                this.writeOutGroup(new int[]{n2++});
            }
        }
        this.currentBlock = 0;
    }

    private void writeOutGroup(int[] nArray) throws IOException {
        int[] nArray2 = PostLh5Encoder.margeArrays(nArray, this.blockCodeFreq);
        int[] nArray3 = PostLh5Encoder.margeArrays(nArray, this.blockOffLenFreq);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += this.blockSize[nArray[i]];
        }
        if (0 < n) {
            int n2;
            Object[] objectArray;
            this.out.writeBits(16, n);
            int[] nArray4 = StaticHuffman.FreqListToLenList(nArray2);
            int[] nArray5 = StaticHuffman.LenListToCodeList(nArray4);
            int[] nArray6 = StaticHuffman.FreqListToLenList(nArray3);
            int[] nArray7 = StaticHuffman.LenListToCodeList(nArray6);
            if (2 <= PostLh5Encoder.countNoZeroElement(nArray2)) {
                int[] nArray8 = PostLh5Encoder.createCodeLenFreq(nArray4);
                objectArray = StaticHuffman.FreqListToLenList(nArray8);
                int[] nArray9 = StaticHuffman.LenListToCodeList(objectArray);
                if (2 <= PostLh5Encoder.countNoZeroElement(nArray8)) {
                    this.writeCodeLenLen((int[])objectArray);
                } else {
                    this.out.writeBits(5, 0);
                    this.out.writeBits(5, PostLh5Encoder.getNoZeroElementIndex(nArray8));
                }
                this.writeCodeLen(nArray4, (int[])objectArray, nArray9);
            } else {
                this.out.writeBits(10, 0);
                this.out.writeBits(18, PostLh5Encoder.getNoZeroElementIndex(nArray2));
            }
            if (2 <= PostLh5Encoder.countNoZeroElement(nArray3)) {
                this.writeOffLenLen(nArray6);
            } else {
                int n3 = Bits.len(Bits.len(this.DictionarySize));
                this.out.writeBits(n3, 0);
                this.out.writeBits(n3, PostLh5Encoder.getNoZeroElementIndex(nArray3));
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.position = 0;
                this.flagBit = 0;
                objectArray = this.block[nArray[n2]];
                for (int i = 0; i < this.blockSize[nArray[n2]]; ++i) {
                    int n4;
                    if (this.flagBit == 0) {
                        this.flagBit = 128;
                        ++this.position;
                        this.flagPos = this.flagPos;
                    }
                    if (0 == (objectArray[this.flagPos] & this.flagBit)) {
                        n4 = objectArray[this.position++] & 0xFF;
                        this.out.writeBits(nArray4[n4], nArray5[n4]);
                    } else {
                        int n5;
                        n4 = objectArray[this.position++] & 0xFF | 0x100;
                        int n6 = 0;
                        for (n5 = 0; n5 < this.DictionarySizeByteLen; ++n5) {
                            n6 = n6 << 8 | objectArray[this.position++] & 0xFF;
                        }
                        n5 = Bits.len(n6);
                        this.out.writeBits(nArray4[n4], nArray5[n4]);
                        this.out.writeBits(nArray6[n5], nArray7[n5]);
                        if (1 < n5) {
                            this.out.writeBits(n5 - 1, n6);
                        }
                    }
                    this.flagBit >>= 1;
                }
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n7;
                this.blockSize[nArray[n2]] = 0;
                nArray2 = this.blockCodeFreq[nArray[n2]];
                for (n7 = 0; n7 < nArray2.length; ++n7) {
                    nArray2[n7] = 0;
                }
                nArray3 = this.blockOffLenFreq[nArray[n2]];
                for (n7 = 0; n7 < nArray3.length; ++n7) {
                    nArray3[n7] = 0;
                }
            }
        }
    }

    private void writeCodeLenLen(int[] nArray) throws IOException {
        int n;
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        this.out.writeBits(5, n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = nArray[n2++]) <= 6) {
                this.out.writeBits(3, n3);
            } else {
                this.out.writeBits(n3 - 3, (1 << n3 - 3) - 2);
            }
            if (n2 != 3) continue;
            while (nArray[n2] == 0 && n2 < 6) {
                ++n2;
            }
            this.out.writeBits(2, n2 - 3 & 3);
        }
    }

    private void writeCodeLen(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        int n;
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        this.out.writeBits(9, n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (0 < (n3 = nArray[n2++])) {
                this.out.writeBits(nArray2[n3 + 2], nArray3[n3 + 2]);
                continue;
            }
            int n4 = 1;
            while (nArray[n2] == 0 && n2 < n) {
                ++n4;
                ++n2;
            }
            if (n4 <= 2) {
                for (int i = 0; i < n4; ++i) {
                    this.out.writeBits(nArray2[0], nArray3[0]);
                }
                continue;
            }
            if (n4 <= 18) {
                this.out.writeBits(nArray2[1], nArray3[1]);
                this.out.writeBits(4, n4 - 3);
                continue;
            }
            if (n4 == 19) {
                this.out.writeBits(nArray2[0], nArray3[0]);
                this.out.writeBits(nArray2[1], nArray3[1]);
                this.out.writeBits(4, 15);
                continue;
            }
            this.out.writeBits(nArray2[2], nArray3[2]);
            this.out.writeBits(9, n4 - 20);
        }
    }

    private void writeOffLenLen(int[] nArray) throws IOException {
        int n;
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        int n2 = Bits.len(Bits.len(this.DictionarySize));
        this.out.writeBits(n2, n);
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = nArray[n3++]) <= 6) {
                this.out.writeBits(3, n2);
                continue;
            }
            this.out.writeBits(n2 - 3, (1 << n2 - 3) - 2);
        }
    }

    private static int countNoZeroElement(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (0 == nArray[i]) continue;
            ++n;
        }
        return n;
    }

    private static int getNoZeroElementIndex(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (0 == nArray[i]) continue;
            return i;
        }
        return 0;
    }

    private static int[] margeArrays(int[] nArray, int[][] nArray2) {
        if (1 < nArray.length) {
            int[] nArray3 = new int[nArray2[0].length];
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray4 = nArray2[nArray[i]];
                for (int j = 0; j < nArray4.length; ++j) {
                    int n = j;
                    nArray3[n] = nArray3[n] + nArray4[j];
                }
            }
            return nArray3;
        }
        return nArray2[nArray[0]];
    }

    private static int[] createCodeLenFreq(int[] nArray) {
        int n;
        int[] nArray2 = new int[19];
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (0 < (n3 = nArray[n2++])) {
                int n4 = n3 + 2;
                nArray2[n4] = nArray2[n4] + 1;
                continue;
            }
            int n5 = 1;
            while (nArray[n2] == 0 && n2 < n) {
                ++n5;
                ++n2;
            }
            if (n5 <= 2) {
                nArray2[0] = nArray2[0] + n5;
                continue;
            }
            if (n5 <= 18) {
                nArray2[1] = nArray2[1] + 1;
                continue;
            }
            if (n5 == 19) {
                nArray2[0] = nArray2[0] + 1;
                nArray2[1] = nArray2[1] + 1;
                continue;
            }
            nArray2[2] = nArray2[2] + 1;
        }
        return nArray2;
    }

    private static int calcHuffmanCodeLength(int n, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3;
        int[] nArray4;
        int n3 = 0;
        try {
            nArray4 = StaticHuffman.FreqListToLenList(nArray);
            int[] nArray5 = StaticHuffman.LenListToCodeList(nArray4);
            nArray3 = StaticHuffman.FreqListToLenList(nArray2);
        }
        catch (BadHuffmanTableException badHuffmanTableException) {
            throw new Error("caught the BadHuffmanTableException which should be never thrown.");
        }
        n3 += 16;
        if (2 <= PostLh5Encoder.countNoZeroElement(nArray)) {
            int[] nArray6 = PostLh5Encoder.createCodeLenFreq(nArray4);
            int[] nArray7 = StaticHuffman.FreqListToLenList(nArray6);
            if (2 <= PostLh5Encoder.countNoZeroElement(nArray6)) {
                n3 += PostLh5Encoder.calcCodeLenLen(nArray7);
            } else {
                n3 += 5;
                n3 += 5;
            }
            n3 += PostLh5Encoder.calcCodeLen(nArray4, nArray7);
        } else {
            n3 += 10;
            n3 += 18;
        }
        if (2 <= PostLh5Encoder.countNoZeroElement(nArray2)) {
            n3 += PostLh5Encoder.calcOffLenLen(n, nArray3);
        } else {
            int n4 = Bits.len(Bits.len(n));
            n3 += n4;
            n3 += n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += nArray[n2] * nArray4[n2];
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n3 += nArray2[n2] * (nArray3[n2] + n2 - 1);
        }
        return n3;
    }

    private static int calcCodeLenLen(int[] nArray) {
        int n;
        int n2 = 0;
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        n2 += 5;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            n2 = (n4 = nArray[n3++]) <= 6 ? (n2 += n4) : (n2 += n4 - 3);
            if (n3 != 3) continue;
            while (nArray[n3] == 0 && n3 < 6) {
                ++n3;
            }
            n2 += 2;
        }
        return n2;
    }

    private static int calcCodeLen(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        for (n = nArray.length; 0 < n && nArray[n - 1] == 0; --n) {
        }
        n2 += 9;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (0 < (n4 = nArray[n3++])) {
                n2 += nArray2[n4 + 2];
                continue;
            }
            int n5 = 1;
            while (nArray[n3] == 0 && n3 < n) {
                ++n5;
                ++n3;
            }
            if (n5 <= 2) {
                for (int i = 0; i < n5; ++i) {
                    n2 += nArray2[0];
                }
                continue;
            }
            if (n5 <= 18) {
                n2 += nArray2[1];
                n2 += 4;
                continue;
            }
            if (n5 == 19) {
                n2 += nArray2[0];
                n2 += nArray2[1];
                n2 += 4;
                continue;
            }
            n2 += nArray2[2];
            n2 += 9;
        }
        return n2;
    }

    private static int calcOffLenLen(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        for (n2 = nArray.length; 0 < n2 && nArray[n2 - 1] == 0; --n2) {
        }
        n3 += Bits.len(Bits.len(n));
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            if ((n5 = nArray[n4++]) <= 6) {
                n3 += 3;
                continue;
            }
            n3 += n5 - 3;
        }
        return n3;
    }

    private static int[][] createGroup(int n, int n2) {
        int[][] nArrayArray = new int[(n + 1) * n / 2][];
        if (n2 == 0) {
            nArrayArray[0] = new int[n];
            for (int i = 0; i < n; ++i) {
                nArrayArray[0][i] = i;
            }
        } else if (2 < n && n2 == 1) {
            int n3 = 0;
            for (int i = n; 0 < i; --i) {
                int n4;
                nArrayArray[n3] = new int[i];
                for (n4 = 0; n4 < i; ++n4) {
                    nArrayArray[n3][n4] = n4;
                }
                if (i < n) {
                    nArrayArray[n3 += n - i] = new int[i];
                    for (n4 = 0; n4 < i; ++n4) {
                        nArrayArray[n3][n4] = n4 + n - i;
                    }
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            for (int i = n; 0 < i; --i) {
                int n6 = 0;
                while (i + n6 <= n) {
                    nArrayArray[n5] = new int[i];
                    for (int j = 0; j < i; ++j) {
                        nArrayArray[n5][j] = n6 + j;
                    }
                    ++n5;
                    ++n6;
                }
            }
        }
        return nArrayArray;
    }

    private static int[][] createPattern(int n, int n2) {
        int n3 = 0;
        int n4 = PostLh5Encoder.calcPatternNum(n, n2);
        int[][] nArrayArray = new int[n4][];
        for (int i = 0; i < Math.min(n, n2 + 1); ++i) {
            int n5;
            int[] nArray = new int[i];
            for (n5 = 0; n5 < nArray.length; ++n5) {
                nArray[n5] = n5;
            }
            do {
                int n6;
                int n7;
                int n8;
                nArrayArray[n3] = new int[i + 1];
                int n9 = 0;
                for (n8 = 0; n8 < nArray.length; ++n8) {
                    n7 = nArray[n8] - n9 + 1;
                    n6 = n - n7;
                    nArrayArray[n3][n8] = (n6 + 1) * n6 / 2 + n9;
                    n9 += n7;
                }
                n8 = n - (n - n9);
                nArrayArray[n3][nArray.length] = (n8 + 1) * n8 / 2 + n9;
                ++n3;
                n5 = 0;
                n6 = n - 2;
                for (n7 = nArray.length - 1; 0 <= n7 && n5 == 0; --n7) {
                    if (nArray[n7] < n6) {
                        int n10 = n7;
                        nArray[n10] = nArray[n10] + 1;
                        if (n7 < nArray.length - 1) {
                            for (int j = n7; j < nArray.length - 1; ++j) {
                                nArray[j + 1] = nArray[j] + 1;
                            }
                        }
                        n5 = 1;
                    }
                    n6 = nArray[n7] - 1;
                }
            } while (n5 != 0);
        }
        return nArrayArray;
    }

    private static int calcPatternNum(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i <= n2; ++i) {
            int n4;
            int n5 = i <= n / 2 ? i : n - 1 - i;
            int n6 = 1;
            for (n4 = 1; n4 <= n5; ++n4) {
                n6 *= n - n4;
            }
            n4 = 1;
            for (int j = 1; j <= n5; ++j) {
                n4 *= j;
            }
            n3 += n6 / n4;
        }
        return n3;
    }
}

