/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh1Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 60;
    private static final int Threshold = 3;
    BitInputStream in;
    DynamicHuffman huffman;
    int[] offHiLen;
    short[] offHiTable;
    int offHiTableBits;
    DynamicHuffman markHuffman;

    public PreLh1Decoder(InputStream inputStream) {
        if (inputStream != null) {
            this.in = inputStream instanceof BitInputStream ? (BitInputStream)inputStream : new BitInputStream(inputStream);
            this.huffman = new DynamicHuffman(314);
            this.markHuffman = null;
            this.offHiLen = PreLh1Decoder.createLenList();
            try {
                this.offHiTable = StaticHuffman.createTable(this.offHiLen);
            }
            catch (BadHuffmanTableException badHuffmanTableException) {
                // empty catch block
            }
        } else {
            throw new NullPointerException("in");
        }
        this.offHiTableBits = Bits.len(this.offHiTable.length - 1);
    }

    @Override
    public int readCode() throws IOException {
        int n = this.huffman.childNode(0);
        while (0 <= n) {
            n = this.huffman.childNode(n - (this.in.readBoolean() ? 1 : 0));
        }
        int n2 = ~n;
        this.huffman.update(n2);
        return n2;
    }

    @Override
    public int readOffset() throws IOException {
        short s = this.offHiTable[this.in.peekBits(this.offHiTableBits)];
        this.in.skipBits(this.offHiLen[s]);
        return s << 6 | this.in.readBits(6);
    }

    @Override
    public void mark(int n) {
        this.in.mark(n * 18 / 8 + 4);
        this.markHuffman = (DynamicHuffman)this.huffman.clone();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.huffman = (DynamicHuffman)this.markHuffman.clone();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 18 - 4, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.huffman = null;
        this.markHuffman = null;
        this.offHiLen = null;
        this.offHiTable = null;
        this.offHiTableBits = 0;
    }

    @Override
    public int getDictionarySize() {
        return 4096;
    }

    @Override
    public int getMaxMatch() {
        return 60;
    }

    @Override
    public int getThreshold() {
        return 3;
    }

    private static int[] createLenList() {
        int[] nArray = new int[]{3, 1, 4, 12, 24, 48, 0};
        int[] nArray2 = new int[64];
        int n = 0;
        int n2 = nArray[n++];
        for (int i = 0; i < 64; ++i) {
            if (nArray[n] == i) {
                ++n;
            }
            nArray2[i] = ++n2;
        }
        return nArray2;
    }
}

