/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh5Decoder
implements PreLzssDecoder {
    private InputStream in;
    private byte[] cache;
    private int cacheLimit;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;
    private int blockSize;
    private int[] codeLen;
    private short[] codeTable;
    private int codeTableBits;
    private short[][] codeTree;
    private int[] offLenLen;
    private short[] offLenTable;
    private int offLenTableBits;
    private short[][] offLenTree;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCacheLimit;
    private int markCachePosition;
    private int markBitBuffer;
    private int markBitCount;
    private int markBlockSize;
    private int[] markCodeLen;
    private short[] markCodeTable;
    private short[][] markCodeTree;
    private int[] markOffLenLen;
    private short[] markOffLenTable;
    private short[][] markOffLenTree;

    private PreLh5Decoder() {
    }

    public PreLh5Decoder(InputStream inputStream) {
        this(inputStream, "-lh5-", 12, 8);
    }

    public PreLh5Decoder(InputStream inputStream, String string) {
        this(inputStream, string, 12, 8);
    }

    public PreLh5Decoder(InputStream inputStream, String string, int n, int n2) {
        if ("-lh4-".equals(string) || "-lh5-".equals(string) || "-lh6-".equals(string) || "-lh7-".equals(string)) {
            this.DictionarySize = CompressMethod.toDictionarySize(string);
            this.MaxMatch = CompressMethod.toMaxMatch(string);
            this.Threshold = CompressMethod.toThreshold(string);
            if (inputStream == null || 0 >= n || 0 >= n2) {
                if (inputStream == null) {
                    throw new NullPointerException("in");
                }
                if (n <= 0) {
                    throw new IllegalArgumentException("CodeTableBits too small. CodeTableBits must be larger than 1.");
                }
                throw new IllegalArgumentException("OffHiTableBits too small. OffHiTableBits must be larger than 1.");
            }
        } else {
            if (null == string) {
                throw new NullPointerException("method");
            }
            throw new IllegalArgumentException("Unknown compress method " + string);
        }
        this.in = inputStream;
        this.cache = new byte[1024];
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.blockSize = 0;
        this.codeTableBits = n;
        this.offLenTableBits = n2;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
    }

    @Override
    public int readCode() throws IOException {
        int n;
        short s;
        if (this.blockSize <= 0) {
            this.readBlockHead();
        }
        --this.blockSize;
        if (this.bitCount < 16) {
            if (2 <= this.cacheLimit - this.cachePosition) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount | (this.cache[this.cachePosition++] & 0xFF) << 16 - this.bitCount;
                this.bitCount += 16;
            } else {
                int n2;
                this.fillBitBuffer();
                short s2 = this.codeTable[this.bitBuffer >>> 32 - this.codeTableBits];
                if (0 <= s2) {
                    n2 = this.bitBuffer << this.codeTableBits;
                    do {
                        s2 = this.codeTree[n2 >>> 31][s2];
                        n2 <<= 1;
                    } while (0 <= s2);
                }
                if ((n2 = this.codeLen[~s2]) <= this.bitCount) {
                    this.bitBuffer <<= n2;
                    this.bitCount -= n2;
                    return ~s2;
                }
                this.bitCount = 0;
                this.bitBuffer = 0;
                throw new EOFException();
            }
        }
        if (0 <= (s = this.codeTable[this.bitBuffer >>> 32 - this.codeTableBits])) {
            n = this.bitBuffer << this.codeTableBits;
            do {
                s = this.codeTree[n >>> 31][s];
                n <<= 1;
            } while (0 <= s);
        }
        n = this.codeLen[~s];
        this.bitBuffer <<= n;
        this.bitCount -= n;
        return ~s;
    }

    @Override
    public int readOffset() throws IOException {
        int n;
        short s;
        if (this.bitCount < 16) {
            if (2 <= this.cacheLimit - this.cachePosition) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount | (this.cache[this.cachePosition++] & 0xFF) << 16 - this.bitCount;
                this.bitCount += 16;
            } else {
                this.fillBitBuffer();
            }
        }
        if (0 <= (s = this.offLenTable[this.bitBuffer >>> 32 - this.offLenTableBits])) {
            n = this.bitBuffer << this.offLenTableBits;
            do {
                s = this.offLenTree[n >>> 31][s];
                n <<= 1;
            } while (0 <= s);
        }
        n = ~s;
        int n2 = this.offLenLen[n];
        this.bitBuffer <<= n2;
        this.bitCount -= n2;
        if (0 <= --n) {
            return 1 << n | this.readBits(n);
        }
        return 0;
    }

    @Override
    public void mark(int n) {
        if (this.blockSize < n) {
            n = n * 16 / 8;
            n += 272;
        } else {
            n = n * 16 / 8;
        }
        n -= this.cacheLimit - this.cachePosition;
        n -= this.bitCount / 8;
        n += 4;
        n = (n + this.cache.length - 1) / this.cache.length * this.cache.length;
        this.in.mark(n);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markBitBuffer = this.bitBuffer;
        this.markBitCount = this.bitCount;
        this.markPositionIsInCache = true;
        this.markBlockSize = this.blockSize;
        this.markCodeLen = this.codeLen;
        this.markCodeTable = this.codeTable;
        this.markCodeTree = this.codeTree;
        this.markOffLenLen = this.offLenLen;
        this.markOffLenTable = this.offLenTable;
        this.markOffLenTree = this.offLenTree;
    }

    @Override
    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
            this.blockSize = this.markBlockSize;
            this.codeLen = this.markCodeLen;
            this.codeTable = this.markCodeTable;
            this.codeTree = this.markCodeTree;
            this.offLenLen = this.markOffLenLen;
            this.offLenTable = this.markOffLenTable;
            this.offLenTree = this.markOffLenTree;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
            this.blockSize = this.markBlockSize;
            this.codeLen = this.markCodeLen;
            this.codeTable = this.markCodeTable;
            this.codeTree = this.markCodeTree;
            this.offLenLen = this.markOffLenLen;
            this.offLenTable = this.markOffLenTable;
            this.offLenTree = this.markOffLenTree;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        int n = this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
        n += this.bitCount - 32;
        if (this.blockSize < (n /= 16)) {
            n -= 272;
        }
        return Math.max(n, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
        this.markPositionIsInCache = false;
        this.blockSize = 0;
        this.codeLen = null;
        this.codeTable = null;
        this.codeTree = null;
        this.offLenLen = null;
        this.offLenTable = null;
        this.offLenTree = null;
        this.markBlockSize = 0;
        this.markCodeLen = null;
        this.markCodeTable = null;
        this.markCodeTree = null;
        this.markOffLenLen = null;
        this.markOffLenTable = null;
        this.markOffLenTree = null;
    }

    @Override
    public int getDictionarySize() {
        return this.DictionarySize;
    }

    @Override
    public int getMaxMatch() {
        return this.MaxMatch;
    }

    @Override
    public int getThreshold() {
        return this.Threshold;
    }

    private void readBlockHead() throws IOException {
        int n;
        short[][] sArray;
        short[] sArray2;
        try {
            this.blockSize = this.readBits(16);
        }
        catch (BitDataBrokenException bitDataBrokenException) {
            if (bitDataBrokenException.getCause() instanceof EOFException) {
                throw (EOFException)bitDataBrokenException.getCause();
            }
            throw bitDataBrokenException;
        }
        int[] nArray = this.readCodeLenLen();
        if (null != nArray) {
            sArray2 = StaticHuffman.createTable(nArray);
        } else {
            sArray2 = new short[]{(short)this.readBits(5)};
            nArray = new int[sArray2[0] + 1];
        }
        this.codeLen = this.readCodeLen(sArray2, nArray);
        if (null != this.codeLen) {
            sArray = StaticHuffman.createTableAndTree(this.codeLen, this.codeTableBits);
            this.codeTable = sArray[0];
            this.codeTree = new short[][]{sArray[1], sArray[2]};
        } else {
            int n2 = this.readBits(9);
            this.codeLen = new int[256 + this.MaxMatch - this.Threshold + 1];
            this.codeTable = new short[1 << this.codeTableBits];
            for (n = 0; n < this.codeTable.length; ++n) {
                this.codeTable[n] = (short)(~n2);
            }
            this.codeTree = new short[][]{new short[0], new short[0]};
        }
        this.offLenLen = this.readOffLenLen();
        if (null != this.offLenLen) {
            sArray = StaticHuffman.createTableAndTree(this.offLenLen, this.offLenTableBits);
            this.offLenTable = sArray[0];
            this.offLenTree = new short[][]{sArray[1], sArray[2]};
        } else {
            int n3 = this.readBits(Bits.len(Bits.len(this.DictionarySize)));
            this.offLenLen = new int[Bits.len(this.DictionarySize)];
            this.offLenTable = new short[1 << this.offLenTableBits];
            for (n = 0; n < this.offLenTable.length; ++n) {
                this.offLenTable[n] = (short)(~n3);
            }
            this.offLenTree = new short[][]{new short[0], new short[0]};
        }
    }

    private int[] readCodeLenLen() throws IOException {
        int n = this.readBits(5);
        if (0 < n) {
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.readBits(3);
                if (n3 == 7) {
                    while (this.readBoolean()) {
                        ++n3;
                    }
                }
                nArray[n2++] = n3;
                if (n2 != 3) continue;
                n2 += this.readBits(2);
            }
            return nArray;
        }
        return null;
    }

    private int[] readCodeLen(short[] sArray, int[] nArray) throws IOException {
        int n = Bits.len(sArray.length - 1);
        int n2 = this.readBits(9);
        if (0 < n2) {
            int[] nArray2 = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.fillBitBuffer();
                int n4 = 0 < n ? this.bitBuffer >>> 32 - n : 0;
                short s = sArray[n4];
                int n5 = nArray[s];
                this.bitBuffer <<= n5;
                this.bitCount -= n5;
                if (s == 0) {
                    ++n3;
                    continue;
                }
                if (s == 1) {
                    n3 += this.readBits(4) + 3;
                    continue;
                }
                if (s == 2) {
                    n3 += this.readBits(9) + 20;
                    continue;
                }
                nArray2[n3++] = s - 2;
            }
            return nArray2;
        }
        return null;
    }

    private int[] readOffLenLen() throws IOException {
        int n = this.readBits(Bits.len(Bits.len(this.DictionarySize)));
        if (0 < n) {
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.readBits(3);
                if (n3 == 7) {
                    while (this.readBoolean()) {
                        ++n3;
                    }
                }
                nArray[n2++] = n3;
            }
            return nArray;
        }
        return null;
    }

    private boolean readBoolean() throws IOException {
        if (0 < this.bitCount) {
            boolean bl = this.bitBuffer < 0;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bl;
        }
        this.fillBitBuffer();
        boolean bl = this.bitBuffer < 0;
        this.bitBuffer <<= 1;
        --this.bitCount;
        return bl;
    }

    private int readBits(int n) throws IOException {
        if (0 < n) {
            if (n <= this.bitCount) {
                int n2 = this.bitBuffer >>> 32 - n;
                this.bitBuffer <<= n;
                this.bitCount -= n;
                return n2;
            }
            int n3 = n;
            int n4 = 0;
            try {
                this.fillBitBuffer();
                while (this.bitCount < n) {
                    if ((n -= this.bitCount) < 32) {
                        n4 |= this.bitBuffer >>> 32 - this.bitCount << n;
                    }
                    this.bitBuffer = 0;
                    this.bitCount = 0;
                    this.fillBitBuffer();
                }
                this.bitBuffer <<= n;
                this.bitCount -= n;
                return n4 |= this.bitBuffer >>> 32 - n;
            }
            catch (LocalEOFException localEOFException) {
                if (localEOFException.thrownBy(this) && n < n3) {
                    throw new BitDataBrokenException(localEOFException, n4 >>> n, n3 - n);
                }
                throw localEOFException;
            }
        }
        return 0;
    }

    private int cachedBits() {
        return this.bitCount + (this.cacheLimit - this.cachePosition << 3);
    }

    private void fillBitBuffer() throws IOException {
        if (32 <= this.cachedBits()) {
            if (this.bitCount <= 24) {
                if (this.bitCount <= 16) {
                    if (this.bitCount <= 8) {
                        if (this.bitCount <= 0) {
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount = 8;
                        }
                        this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                        this.bitCount += 8;
                    }
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
        } else if (this.bitCount < 25) {
            if (this.bitCount == 0) {
                this.bitBuffer = 0;
            }
            int n = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
            while (0 < n--) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                n = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
                while (0 < n--) {
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
            } else if (this.bitCount <= 0) {
                throw new LocalEOFException(this);
            }
        }
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int n = 0;
        while (0 <= n && this.cacheLimit < this.cache.length) {
            n = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (0 >= n) continue;
            this.cacheLimit += n;
        }
    }

    private static class LocalEOFException
    extends EOFException {
        private Object owner;

        public LocalEOFException(Object object) {
            this.owner = object;
        }

        public boolean thrownBy(Object object) {
            return this.owner == object;
        }
    }
}

