/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;

public class StaticHuffman {
    public static final int LimitLen = 16;

    private StaticHuffman() {
    }

    public static int[] FreqListToLenList(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length * 2 - 1];
        int[] nArray3 = new int[nArray.length * 2 - 1];
        int[] nArray4 = new int[nArray.length * 2 - 1];
        int n2 = nArray.length;
        int[] nArray5 = new int[nArray.length];
        int n3 = 0;
        int[] nArray6 = new int[nArray.length - 1];
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n];
            if (0 >= nArray[n]) continue;
            nArray5[n3++] = n;
        }
        if (2 <= n3) {
            int n5;
            StaticHuffman.MergeSort(nArray5, 0, n3 - 1, nArray, new int[n3 / 2 + 1]);
            n = 0;
            int n6 = 0;
            do {
                int n7 = n4 <= n6 ? nArray5[n++] : (n3 <= n ? nArray6[n6++] : (nArray2[nArray5[n]] <= nArray2[nArray6[n6]] ? nArray5[n++] : nArray6[n6++]));
                int n8 = n4 <= n6 ? nArray5[n++] : (n3 <= n ? nArray6[n6++] : (nArray2[nArray5[n]] <= nArray2[nArray6[n6]] ? nArray5[n++] : nArray6[n6++]));
                n5 = n2++;
                nArray2[n5] = nArray2[n7] + nArray2[n8];
                nArray3[n5] = n7;
                nArray4[n5] = n8;
                nArray6[n4++] = n5;
            } while (n6 + n < n4 + n3 - 1);
            int[] nArray7 = StaticHuffman.HuffmanTreeToLenFreq(nArray3, nArray4, n2 - 1);
            int[] nArray8 = new int[nArray.length];
            n = 0;
            n5 = 16;
            while (0 < n5) {
                while (true) {
                    int n9 = n5--;
                    int n10 = nArray7[n9];
                    nArray7[n9] = n10 - 1;
                    if (0 >= n10) break;
                    nArray8[nArray5[n++]] = n5;
                }
            }
            return nArray8;
        }
        return new int[nArray.length];
    }

    public static int[] FreqListToLenListOriginal(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length * 2 - 1];
        int[] nArray3 = new int[nArray.length * 2 - 1];
        int[] nArray4 = new int[nArray.length * 2 - 1];
        int n2 = nArray.length;
        int[] nArray5 = new int[nArray.length];
        int n3 = 0;
        int[] nArray6 = new int[nArray.length * 2];
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n];
            if (0 >= nArray[n]) continue;
            nArray6[++n4] = n;
        }
        if (2 <= n4) {
            int n5;
            for (n = n4 / 2; 1 <= n; --n) {
                StaticHuffman.DownHeap(nArray6, n4, nArray2, n);
            }
            do {
                if ((n = nArray6[1]) < nArray.length) {
                    nArray5[n3++] = n;
                }
                nArray6[1] = nArray6[n4--];
                StaticHuffman.DownHeap(nArray6, n4, nArray2, 1);
                int n6 = nArray6[1];
                if (n6 < nArray.length) {
                    nArray5[n3++] = n6;
                }
                n5 = n2++;
                nArray2[n5] = nArray2[n] + nArray2[n6];
                nArray3[n5] = n;
                nArray4[n5] = n6;
                nArray6[1] = n5;
                StaticHuffman.DownHeap(nArray6, n4, nArray2, 1);
            } while (1 < n4);
            int[] nArray7 = StaticHuffman.HuffmanTreeToLenFreq(nArray3, nArray4, n2 - 1);
            int[] nArray8 = new int[nArray.length];
            n5 = 0;
            int n7 = 16;
            while (0 < n7) {
                while (true) {
                    int n8 = n7--;
                    int n9 = nArray7[n8];
                    nArray7[n8] = n9 - 1;
                    if (0 >= n9) break;
                    nArray8[nArray5[n5++]] = n7;
                }
            }
            return nArray8;
        }
        return new int[nArray.length];
    }

    public static int[] LenListToCodeList(int[] nArray) throws BadHuffmanTableException {
        int n;
        int[] nArray2 = new int[17];
        int[] nArray3 = new int[18];
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            nArray2[n2] = nArray2[n2] + 1;
        }
        if (nArray2[0] < nArray.length) {
            for (n = 1; n <= 16; ++n) {
                nArray3[n + 1] = nArray3[n] + nArray2[n] << 1;
            }
            if (nArray3[17] != 131072) {
                throw new BadHuffmanTableException();
            }
            int[] nArray4 = new int[nArray.length];
            for (int i = 0; i < nArray4.length; ++i) {
                if (0 >= nArray[i]) continue;
                int n3 = nArray[i];
                nArray3[n3] = nArray3[n3] + 1;
            }
            return nArray4;
        }
        return new int[nArray.length];
    }

    public static short[] createTable(int[] nArray) throws BadHuffmanTableException {
        int[] nArray2 = StaticHuffman.LenListToCodeList(nArray);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n > nArray[i]) continue;
            n = nArray[i];
            n2 = i;
        }
        short[] sArray = new short[1 << n];
        for (int i = 0; i < nArray.length; ++i) {
            if (0 >= nArray[i]) continue;
            int n3 = nArray2[i] << n - nArray[i];
            int n4 = i != n2 ? n3 + (1 << n - nArray[i]) : sArray.length;
            for (int j = n3; j < n4; ++j) {
                sArray[j] = (short)i;
            }
        }
        return sArray;
    }

    public static short[][] createTableAndTree(int[] nArray, int n) throws BadHuffmanTableException {
        int[] nArray2 = StaticHuffman.LenListToCodeList(nArray);
        short[] sArray = new short[1 << n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[n2] <= nArray[i]) {
                n2 = i;
            }
            if (n >= nArray[i]) continue;
            int n3 = nArray2[i] >> nArray[i] - n;
            sArray[n3] = (short)(sArray[n3] + 1);
        }
        int n4 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (0 < sArray[i]) {
                n4 += sArray[i] - 1;
            }
            sArray[i] = -1;
        }
        short[] sArray2 = new short[n4];
        short[] sArray3 = new short[n4];
        int n5 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n6;
            int n7;
            int n8;
            if (0 >= nArray[i]) continue;
            int n9 = nArray[i] - n;
            if (n9 <= 0) {
                n8 = nArray2[i] << n - nArray[i];
                n7 = i != n2 ? n8 + (1 << n - nArray[i]) : sArray.length;
                for (n6 = n8; n6 < n7; ++n6) {
                    sArray[n6] = (short)(~i);
                }
                continue;
            }
            n8 = nArray2[i] >> n9;
            if (sArray[n8] == -1) {
                sArray[n8] = (short)n5++;
                n7 = sArray[n8];
            } else {
                n7 = sArray[n8];
            }
            for (n6 = n + 1; n6 < nArray[i]; ++n6) {
                if (0 == (nArray2[i] & 1 << nArray[i] - n6)) {
                    if (sArray2[n7] == 0) {
                        sArray2[n7] = (short)n5++;
                        n7 = sArray2[n7];
                        continue;
                    }
                    n7 = sArray2[n7];
                    continue;
                }
                if (sArray3[n7] == 0) {
                    sArray3[n7] = (short)n5++;
                    n7 = sArray3[n7];
                    continue;
                }
                n7 = sArray3[n7];
            }
            if (0 == (nArray2[i] & 1)) {
                sArray2[n7] = (short)(~i);
                continue;
            }
            sArray3[n7] = (short)(~i);
        }
        return new short[][]{sArray, sArray2, sArray3};
    }

    private static void MergeSort(int[] nArray, int n, int n2, int[] nArray2, int[] nArray3) {
        if (n < n2) {
            int n3 = (n + n2) / 2 + (n + n2) % 2;
            StaticHuffman.MergeSort(nArray, n, n3 - 1, nArray2, nArray3);
            StaticHuffman.MergeSort(nArray, n3, n2, nArray2, nArray3);
            System.arraycopy(nArray, n, nArray3, 0, n3 - n);
            int n4 = n3;
            int n5 = 0;
            int n6 = n;
            while (n4 <= n2 && n5 < n3 - n) {
                nArray[n6++] = nArray2[nArray3[n5]] < nArray2[nArray[n4]] ? nArray3[n5++] : nArray[n4++];
            }
            if (n5 < n3 - n) {
                System.arraycopy(nArray3, n5, nArray, n6, n3 - n - n5);
            }
        }
    }

    private static void DownHeap(int[] nArray, int n, int[] nArray2, int n2) {
        int n3;
        int n4 = nArray[n2];
        while ((n3 = 2 * n2) <= n) {
            if (n3 < n && nArray2[nArray[n3]] > nArray2[nArray[n3 + 1]]) {
                ++n3;
            }
            if (nArray2[n4] <= nArray2[nArray[n3]]) break;
            nArray[n2] = nArray[n3];
            n2 = n3;
        }
        nArray[n2] = n4;
    }

    private static int[] HuffmanTreeToLenFreq(int[] nArray, int[] nArray2, int n) {
        int n2;
        int[] nArray3 = new int[17];
        StaticHuffman.internalHuffmanTreeToLenFreq(nArray, nArray2, n, 0, nArray3);
        int n3 = 0;
        for (n2 = 16; 0 < n2; --n2) {
            n3 += nArray3[n2] << 16 - n2;
        }
        while (65536 < n3) {
            nArray3[16] = nArray3[16] - 1;
            for (n2 = 15; 0 < n2; --n2) {
                if (0 >= nArray3[n2]) continue;
                int n4 = n2;
                nArray3[n4] = nArray3[n4] - 1;
                int n5 = n2 + 1;
                nArray3[n5] = nArray3[n5] + 2;
                break;
            }
            --n3;
        }
        return nArray3;
    }

    private static void internalHuffmanTreeToLenFreq(int[] nArray, int[] nArray2, int n, int n2, int[] nArray3) {
        if (n < (nArray.length + 1) / 2) {
            int n3 = n2 < 16 ? n2 : 16;
            nArray3[n3] = nArray3[n3] + 1;
        } else {
            StaticHuffman.internalHuffmanTreeToLenFreq(nArray, nArray2, nArray[n], n2 + 1, nArray3);
            StaticHuffman.internalHuffmanTreeToLenFreq(nArray, nArray2, nArray2[n], n2 + 1, nArray3);
        }
    }
}

