/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.HashShort;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class TwoLevelHashSearch
implements LzssSearchMethod {
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod primaryHash;
    private int[] primaryHashTable;
    private int[] primaryCount;
    private int[] secondaryHashRequires;
    private int[] secondaryHashTable;
    private int[] dummy;
    private int[] prev;

    private TwoLevelHashSearch() {
    }

    public TwoLevelHashSearch(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, HashShort.class.getName());
    }

    public TwoLevelHashSearch(int n, int n2, int n3, byte[] byArray, String string) {
        int n4;
        this.DictionarySize = n;
        this.MaxMatch = n2;
        this.Threshold = n3;
        this.TextBuffer = byArray;
        this.DictionaryLimit = this.DictionarySize;
        try {
            this.primaryHash = (HashMethod)Factory.createInstance(string, new Object[]{byArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException.getTargetException().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
        this.primaryHashTable = new int[this.primaryHash.tableSize()];
        this.secondaryHashTable = new int[this.primaryHash.tableSize() + this.DictionarySize / 4];
        for (n4 = 0; n4 < this.primaryHashTable.length; ++n4) {
            this.primaryHashTable[n4] = n4;
            this.secondaryHashTable[n4] = -1;
        }
        this.primaryCount = new int[this.primaryHash.tableSize()];
        this.secondaryHashRequires = new int[this.primaryHash.tableSize()];
        this.dummy = new int[this.secondaryHashTable.length];
        this.prev = new int[this.DictionarySize];
        for (n4 = 0; n4 < this.prev.length; ++n4) {
            this.prev[n4] = -1;
        }
    }

    @Override
    public void put(int n) {
        int n2 = this.primaryHash.hash(n);
        int n3 = this.primaryHashTable[n2];
        int n4 = this.secondaryHash(n, this.secondaryHashRequires[n2]);
        int n5 = n2;
        this.primaryCount[n5] = this.primaryCount[n5] + 1;
        this.prev[n & this.DictionarySize - 1] = this.secondaryHashTable[n3 + n4];
        this.secondaryHashTable[n3 + n4] = n;
    }

    @Override
    public int searchAndPut(int n) {
        int n2 = this.Threshold - 1;
        int n3 = n;
        int n4 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
        int n5 = this.primaryHash.hash(n);
        int n6 = this.primaryHashTable[n5];
        int n7 = this.secondaryHashRequires[n5];
        int n8 = this.secondaryHash(n, n7);
        int n9 = this.secondaryHashTable[n6 + n8];
        byte[] byArray = this.TextBuffer;
        int n10 = n + this.MaxMatch;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n4 <= n9) {
            if (byArray[n9 + n2] == byArray[n + n2]) {
                n11 = n9;
                n12 = n;
                while (byArray[n11] == byArray[n12]) {
                    ++n11;
                    if (n10 > ++n12) continue;
                }
                if (n2 < (n13 = n12 - n)) {
                    n3 = n9;
                    n2 = n13;
                    if (n10 <= n12) break;
                }
            }
            n9 = this.prev[n9 & this.DictionarySize - 1];
        }
        int n14 = 1;
        int n15 = n7 - Math.max(0, this.Threshold - this.primaryHash.hashRequires());
        int n16 = this.primaryHash.hashRequires() + n7 - 1;
        int n17 = 1;
        int n18 = 4;
        while (n17 <= n15 && n2 <= n16) {
            n10 += n + n16;
            while (n14 < n18) {
                n9 = this.secondaryHashTable[n6 + (n8 ^ n14)];
                while (n4 <= n9) {
                    if (byArray[n9] == byArray[n]) {
                        n11 = n9 + 1;
                        n12 = n + 1;
                        while (byArray[n11] == byArray[n12]) {
                            ++n11;
                            if (n10 > ++n12) continue;
                        }
                        if (n2 < (n13 = n12 - n) || n2 == n13 && n3 < n9) {
                            n3 = n9;
                            n2 = n13;
                            if (n10 <= n12) {
                                n4 = n9;
                                break;
                            }
                        }
                    }
                    n9 = this.prev[n9 & this.DictionarySize - 1];
                }
                ++n14;
            }
            n16 = this.primaryHash.hashRequires() + n7 - n17 - 1;
            ++n17;
            n18 <<= 2;
        }
        int n19 = n5;
        this.primaryCount[n19] = this.primaryCount[n19] + 1;
        this.prev[n & this.DictionarySize - 1] = this.secondaryHashTable[n6 + n8];
        this.secondaryHashTable[n6 + n8] = n;
        if (this.Threshold <= n2) {
            return LzssOutputStream.createSearchReturn(n2, n3);
        }
        return -1;
    }

    @Override
    public int search(int n, int n2) {
        int n3;
        int n4 = this.Threshold - 1;
        int n5 = n;
        int n6 = Math.max(this.DictionaryLimit, n2);
        byte[] byArray = this.TextBuffer;
        int n7 = Math.min(this.TextBuffer.length, n + this.MaxMatch);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = n - 1; n6 < n3; --n3) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n4 >= n10) continue;
            n5 = n3;
            n4 = n10;
        }
        int n11 = this.primaryHash.hashRequires();
        if (n11 < this.TextBuffer.length - n) {
            int n12;
            int n13;
            int n14;
            int n15 = this.primaryHash.hash(n);
            int n16 = this.primaryHashTable[n15];
            int n17 = this.secondaryHashRequires[n15];
            if (n11 + n17 < this.TextBuffer.length - n) {
                n14 = this.secondaryHash(n, n17);
                n13 = 0;
            } else {
                n12 = this.TextBuffer.length - n - n11;
                n14 = this.secondaryHash(n, n12) << (n17 - n12) * 2;
                n13 = n17 - n12;
            }
            n12 = 0;
            int n18 = n17 - Math.max(0, this.Threshold - this.primaryHash.hashRequires());
            int n19 = this.MaxMatch;
            int n20 = n13;
            int n21 = 1 << n20 * 2;
            while (n20 <= n17) {
                n7 += n + n19;
                while (n12 < n21) {
                    n3 = this.secondaryHashTable[n16 + (n14 ^ n12)];
                    while (n6 <= n3) {
                        if (byArray[n3] == byArray[n]) {
                            n8 = n3 + 1;
                            n9 = n + 1;
                            while (byArray[n8] == byArray[n9]) {
                                ++n8;
                                if (n7 > ++n9) continue;
                            }
                            if (n4 < (n10 = n9 - n) || n4 == n10 && n5 < n3) {
                                n5 = n3;
                                n4 = n10;
                                if (n7 <= n9) {
                                    n6 = n3;
                                    break;
                                }
                            }
                        }
                        n3 = this.prev[n3 & this.DictionarySize - 1];
                    }
                    ++n12;
                }
                n19 = this.primaryHash.hashRequires() + n17 - n20 - 1;
                ++n20;
                n21 <<= 2;
            }
        }
        if (this.Threshold <= n4) {
            return LzssOutputStream.createSearchReturn(n4, n5);
        }
        return -1;
    }

    @Override
    public void slide() {
        int n;
        int n2;
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.primaryHashTable.length; ++i) {
            this.primaryHashTable[i] = n4;
            n2 = this.secondaryHashRequires[i] * 2;
            if (1 << 5 + n2 <= this.primaryCount[i]) {
                for (n = 0; n < 1 << n2; ++n) {
                    this.divide(n4, n3, this.primaryHash.hashRequires() + this.secondaryHashRequires[i]);
                    n4 += 4;
                    ++n3;
                }
                int n5 = i;
                this.secondaryHashRequires[n5] = this.secondaryHashRequires[n5] + 1;
            } else if (0 < n2 && this.primaryCount[i] < 1 << 2 + n2) {
                for (n = 0; n < 1 << n2 - 2; ++n) {
                    this.merge(n4, n3);
                    ++n4;
                    n3 += 4;
                }
                int n6 = i;
                this.secondaryHashRequires[n6] = this.secondaryHashRequires[n6] - 1;
            } else {
                for (n = 0; n < 1 << n2; ++n) {
                    int n7 = this.secondaryHashTable[n3++] - this.DictionarySize;
                    this.dummy[n4++] = 0 <= n7 ? n7 : -1;
                }
            }
            this.primaryCount[i] = 0;
        }
        int[] nArray = this.secondaryHashTable;
        this.secondaryHashTable = this.dummy;
        this.dummy = nArray;
        for (n2 = 0; n2 < this.prev.length; ++n2) {
            n = this.prev[n2] - this.DictionarySize;
            this.prev[n2] = 0 <= n ? n : -1;
        }
    }

    @Override
    public int putRequires() {
        return this.primaryHash.hashRequires() + Math.max(Bits.len(this.DictionarySize) - 5, 0) / 2;
    }

    private int secondaryHash(int n, int n2) {
        int n3 = 0;
        int n4 = n + this.primaryHash.hashRequires();
        while (0 < n2--) {
            n3 <<= 2;
            n3 |= this.TextBuffer[n4++] & 3;
        }
        return n3;
    }

    private void divide(int n, int n2, int n3) {
        int n4;
        int n5 = this.DictionarySize;
        int n6 = this.secondaryHashTable[n2];
        int[] nArray = new int[]{-1, -1, -1, -1};
        while (n5 < n6) {
            n4 = this.TextBuffer[n6 + n3] & 3;
            if (0 < nArray[n4]) {
                this.prev[nArray[n4] & this.DictionarySize - 1] = n6;
            } else {
                this.dummy[n + n4] = n6 - this.DictionarySize;
            }
            nArray[n4] = n6;
            n6 = this.prev[n6 & this.DictionarySize - 1];
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (0 < nArray[n4]) {
                this.prev[nArray[n4] & this.DictionarySize - 1] = -1;
                continue;
            }
            this.dummy[n + n4] = -1;
        }
    }

    private void merge(int n, int n2) {
        int n3 = this.DictionarySize;
        int n4 = -1;
        while (true) {
            int n5 = 0;
            int n6 = this.secondaryHashTable[n2];
            for (int i = 1; i < 4; ++i) {
                if (n6 >= this.secondaryHashTable[n2 + i]) continue;
                n5 = i;
                n6 = this.secondaryHashTable[n2 + i];
            }
            if (n3 >= n6) break;
            this.secondaryHashTable[n2 + n5] = this.prev[n6 & this.DictionarySize - 1];
            if (0 < n4) {
                this.prev[n4 & this.DictionarySize - 1] = n6;
            } else {
                this.dummy[n] = n6 - this.DictionarySize;
            }
            n4 = n6;
        }
        if (0 < n4) {
            this.prev[n4 & this.DictionarySize - 1] = -1;
        } else {
            this.dummy[n] = -1;
        }
    }
}

