(ns atena.gui.AddressTableColumnModel
  (:import (javax.swing JCheckBox
                        DefaultCellEditor)
           (javax.swing.table DefaultTableColumnModel
                              TableCellRenderer
                              TableColumn)
           )
  (:gen-class
   :extends javax.swing.table.DefaultTableColumnModel
   :init init
   :post-init after-ctor
   :state state
   :methods [[getUuidColumn [] Object]]
   ))

(defn -init []
  [[]
   (ref {:column0 (TableColumn.)
         :column1 (TableColumn.)
         :column2 (TableColumn.)
         :column3 (TableColumn.)
         :column4 (TableColumn.)
         :column5 (TableColumn.)
         :column6 (TableColumn.)
        })
   ])

(defn -getUuidColumn
  [this]
  (let [{:keys [column6]} @(.state this)]
    column6))

(defn -after-ctor [this]
  (let [{:keys [column0
                column1
                column2
                column3
                column4
                column5
                column6
               ]} @(.state this)]
    (def renderer (doto (proxy [JCheckBox TableCellRenderer] []
                    (getTableCellRendererComponent [table value isSelected hasFocus row column]
                      (let [check (.getValueAt table row column)]
                        (.setSelected this check)
                        this)))))
    (doto column0
      (.setModelIndex 0)
      (.setHeaderValue "選択")
      (.setPreferredWidth 30)
      (.sizeWidthToFit)
      (.setResizable false)
      (.setCellEditor (DefaultCellEditor. (JCheckBox.)))
      (.setCellRenderer renderer))
    (doto column1
      (.setModelIndex 1)
      (.setResizable true)
      (.setHeaderValue "姓")
      (.setPreferredWidth 60))
    (doto column2
      (.setModelIndex 2)
      (.setResizable true)
      (.setHeaderValue "名")
      (.setPreferredWidth 100))
    (doto column3
      (.setModelIndex 3)
      (.setResizable true)
      (.setHeaderValue "敬称")
      (.setPreferredWidth 60))
    (doto column4
      (.setModelIndex 4)
      (.setResizable true)
      (.setHeaderValue "郵便番号")
      (.setPreferredWidth 70))
    (doto column5
      (.setModelIndex 5)
      (.setResizable true)
      (.setHeaderValue "住所")
      (.setPreferredWidth 300))
    (doto column6
      (.setModelIndex 6)
      (.setResizable false)
      (.setHeaderValue "UUID")
      (.setPreferredWidth 0))
    (doto this
      (.addColumn column0)
      (.addColumn column1)
      (.addColumn column2)
      (.addColumn column3)
      (.addColumn column4)
      (.addColumn column5)
      (.addColumn column6))))
  
