(ns atena.gui.DetailInfoPanel
  (:import (java.awt BorderLayout GridLayout GridBagLayout Insets
                     Font Color Dimension FlowLayout)
           (java.awt.event  ActionListener)
           (java.io File)
           (java.util Calendar UUID)
           (javax.swing JPanel JLabel JTextField JButton JCheckBox JOptionPane JScrollPane)
           (javax.swing.border TitledBorder LineBorder)
           (atena.gui Utility)
           (atena.gui HistoryTable)
           )
  (:require [atena.utils.gridbaglayout])
  (:gen-class
   :extends javax.swing.JPanel
   :init init
   :post-init after-ctor
   :state state
   :methods [[getData [] Object]
             [setData [Object] void]
             [addData [] void]
             [addAssignFromButtonListener [java.awt.event.ActionListener] void]
             [addSaveButtonListener [java.awt.event.ActionListener] void]
             [addDeleteButtonListener [java.awt.event.ActionListener] void]
             [getUuid [] String]
             [createUuid [] String]
             [status [] String]
             [status [String] void]
             [familyName [] String]
             [familyName [String] void]
             [firstNames [] String]
             [firstNames [String] void]
             [honer [] String]
             [honer [String] void]
             [zipCode [] String]
             [zipCode [String] void]
             [address [] String]
             [address [String] void]
             [uuid [] String]
             [uuid [String] void]
             [setMourningsFile [String] void]
             [setHistoriesFile [java.io.File] void]
             [setSenderUuid [String] void]
            ]
   ))

(defn -init []
  [[]
   (ref {:status-label     (JLabel. "[状態]")
         :family-name-text (JTextField.)
         :first-names-text (JTextField.)
         :honer-text       (JTextField. 5)
         :zip-code-text    (JTextField. 7)
         :address-text     (JTextField.)
         :send             (JCheckBox.)
         :mourning         (JCheckBox.)
         :received         (JCheckBox.)
         :save-button      (JButton. "保存")
         :print-button     (JButton. "印刷")
         :delete-button    (JButton. "削除")
         :uuid-text        (JTextField.)
         :history-panel    (atena.gui.HistoryPanel.)
        })])

(atena.gui.Utility/defn-acsr -status     this status-label)
(atena.gui.Utility/defn-acsr -familyName this family-name-text)
(atena.gui.Utility/defn-acsr -firstNames this first-names-text)
(atena.gui.Utility/defn-acsr -honer      this honer-text)
(atena.gui.Utility/defn-acsr -zipCode    this zip-code-text)
(atena.gui.Utility/defn-acsr -address    this address-text)
(atena.gui.Utility/defn-acsr -uuid       this uuid-text)

(defn -setMourningsFile
  [this
   file]
  (let [{:keys [history-panel]} @(.state this)]
    (. history-panel mourningsPath file)))

(defn -setHistoriesFile
  [this
   file]
  (let [{:keys [history-panel]} @(.state this)]
    (. history-panel historiesFile file)
    (. history-panel refresh)))

(defn -setSenderUuid
  [this
   uuid]
  (let [{:keys [history-panel]} @(.state this)]
    (. history-panel sender uuid)
    (. history-panel refresh)))

(defn -setData
  ;差出人データ割り当て処理
  [this data]
  (let [{:keys [history-panel]} @(.state this)]
    (. this familyName (data :family-name))
    (. this firstNames (data :first-names))
    (. this honer      (data :honer))
    (. this zipCode    (data :zcode))
    (. this address    (data :address))
    (. this uuid       (data :uuid))
    (. history-panel uuid (data :uuid))
    (. history-panel refresh)))

(defn -createUuid
  [this]
  (let [value (str (. this familyName)
                   (. this firstNames)
                   (. this honer)
                   (. this zipCode)
                   (. this address)
                   (.. Calendar getInstance getTimeInMillis toString))
        bytes (. value getBytes "UTF-8")
        uuid  (UUID/nameUUIDFromBytes bytes)]
    (. uuid toString)))

(defn -getData
  ;差出人データ割り当て処理
  [this]
  {:family-name (. this familyName)
   :first-names (. this firstNames)
   :honer       (. this honer)
   :zcode       (. this zipCode)
   :address     (. this address)
   :uuid        (. this uuid)})

(defn -addData
  [this]
  (. this status "[新規]")
  (. this familyName "")
  (. this firstNames "")
  (. this honer "")
  (. this zipCode "")
  (. this address "")
  (. this uuid ""))

(atena.gui.Utility/defaddlistener -addSaveButtonListener this save-button)
(atena.gui.Utility/defaddlistener -addDeleteButtonListener this delete-button)
  
(defn -after-ctor [this]
  (let [{:keys [status-label
                family-name-text
                first-names-text
                honer-text
                zip-code-text
                address-text
                send
                mourning
                received
                save-button
                print-button
                delete-button
                history-panel
               ]} @(.state this)]

    (doto this
      (.setLayout (GridBagLayout.))
      (.setBorder (TitledBorder. (LineBorder. Color/GRAY 2)
                                 "宛先詳細情報"
                                 TitledBorder/LEFT
                                 TitledBorder/TOP
                                 (Font. Font/MONOSPACED Font/BOLD 12)))
      (atena.utils.gridbaglayout/grid-bag-layout
        :insets (Insets. 5 5 5 5)
        :weightx 1.0
        :anchor :WEST
        ;ステータスラベル
        :anchor :WEST
        :fill :HORIZONTAL
        :gridx 0
        :gridy 0
        status-label
        :gridy 1
        (doto (JPanel. (FlowLayout. FlowLayout/LEFT))
          (.add save-button)
          (.add print-button)
          (.add delete-button)
        )
        :gridy 2
        (doto (JPanel. (GridBagLayout.))
          (atena.utils.gridbaglayout/grid-bag-layout
            :insets (Insets. 2 2 2 2)
            :anchor :WEST
            :gridx 0
            :gridy 1
            (JLabel. "姓")
            :gridy 2
            (JLabel. "名")
            :gridy 3
            (JLabel. "敬称")
            :gridy 4
            (JLabel. "郵便番号")
            :gridy 5
            (JLabel. "住所")
            ;入力フィールド
            :weightx 1.0
            :fill :HORIZONTAL
            :gridx 1
            :gridy 1
            family-name-text
            :gridy 2
            first-names-text
            :gridy 3
            :weightx 0.0
            :fill :NONE
            honer-text
            :gridy 4
            zip-code-text
            :gridy 5
            :weightx 1.0
            :fill :HORIZONTAL
            address-text
          )
        )
        :gridy 3
        :weighty 1.0
        :fill :BOTH
        ;:fill :VERTICAL
        (doto (JPanel. (GridBagLayout.))
          (atena.utils.gridbaglayout/grid-bag-layout
            :gridx 0
            :gridy 0
            ;:weightx 0.5
            :weightx 0.0
            :weighty 1.0
            :fill :BOTH
            history-panel
            :gridx 1
            ;:weightx 0.5
            :weightx 1.0
            :weighty 1.0
            :fill :BOTH
            (JPanel.)
          )
        )
      )
    )
  )
)
