(ns atena.gui.HistoryTable
  (:import (javax.swing JTable)
           (javax.swing.table TableRowSorter)
           (javax.swing.event ListSelectionListener)
           (atena.gui HistoryTableColumnModel
                      HistoryTableModel)
           )
  (:require [atena.utils.gridbaglayout])
  (:gen-class
   :extends javax.swing.JTable
   :init init
   :post-init after-ctor
   :state state
   :methods []
   ))


(defn -init []
  [[]
   (ref {:model   (atena.gui.HistoryTableModel.)
         :columns (atena.gui.HistoryTableColumnModel.)})
   ])

(defn -after-ctor [this]
  (let [{:keys [model
                columns
               ]} @(.state this)]
    (def sorter (TableRowSorter. model))

    (doto sorter
      (.setSortable 1 false)
      (.setSortable 2 false)
      (.setSortable 3 false))

    (doto this
      (.setModel model)
      (.setColumnModel columns)
      (.setAutoResizeMode JTable/AUTO_RESIZE_OFF)
      (.setFillsViewportHeight true)
      (.setRowSorter sorter)
      )))
