(ns atena.gui.Utility
  (:import (java.awt.event  ActionListener)
           (javax.swing JOptionPane))
  (:gen-class))

(defn make-confirm-ActionListener
  ;確認ダイアログ＋カスタム処理のパターンの共通処理
  [title
   message
   operation-proc]
  (proxy [ActionListener] []
    (actionPerformed [evt]
      (let [ret (. JOptionPane (showConfirmDialog nil message title JOptionPane/YES_NO_OPTION))]
        (if (= JOptionPane/YES_OPTION ret)
            (operation-proc))))))

(defmacro defn-acsr
  "テキストを扱うコントロールへのアクセッサを定義するマクロ"
  [fn-name this container]
  (let [value (gensym "value")]
    `(defn ~fn-name
       ([~this]
         (let [{:keys [~container]} @(.state ~this)]
           (.getText ~container)))
       ([~this ~value]
         (let [{:keys [~container]} @(.state ~this)]
           (.setText ~container ~value))))))

(defmacro defield
  "メンバ変数のアクセッサを定義するマクロ"
  [field-name this]
  (let [method-name (symbol (str "-" field-name))
        value       (gensym "value")]
     `(defn ~method-name
       ([~this]
         (let [{:keys [~field-name]} @(.state ~this)]
           (deref ~field-name)))
       ([~this ~value]
         (let [{:keys [~field-name]} @(.state ~this)]
           (dosync (ref-set ~field-name ~value)))))))
     
(defmacro defaddlistener
  "ボタンにリスナを登録するマクロ"
  [fn-name this button]
  (let [listener (gensym "listener")]
    `(defn ~fn-name
       [~this
        ~listener]
        (let [{:keys [~button]} @(.state ~this)]
          (. ~button addActionListener ~listener)))))
