(ns atena.utils.lzh
  (:use [clojure.contrib.io :rename {spit io-spit}])
  (:import (java.io File
                    FileInputStream
                    FileOutputStream)
           (jp.gr.java_conf.dangan.util.lha LhaInputStream
                                            LhaHeader)))

(defn decompress
  "Decompress lzh file."
  [lzh-file-path]
  (let [lzh-file   (File. lzh-file-path)]
    (with-open [reader (LhaInputStream. (FileInputStream. lzh-file))]
      (let [header   (. reader getNextEntry)
            out-file (File. (. lzh-file getParent) (. header getPath))]
        (with-open [writer (FileOutputStream. out-file)]
          (copy reader writer))))))
