/* 
Taito Type X and Type X2 System Driver File By Gemuno@Masatti 
   This document is Work-In-Progress.

Driver Info 

CPU Intel Celelon 2.5Ghz            (Type X)
         Core 2 Duo 2.5Ghz??     (Type X-2)

CPU2 RADEON ?.?GHz

SPU ???

ROM DEVICES HDD(Not defined)+BIOS+Security Dongle

Driver Info End 
*/

#include "driver.h"
#include "memconv.h"
#include "machine/8237dma.h"
#include "machine/pic8259.h"
#include "machine/pit8253.h"
#include "machine/mc146818.h"
#include "machine/pcshare.h"
#include "machine/pci.h"
#include "machine/8042kbdc.h"
#include "machine/pckeybrd.h"
#include "machine/idectrl.h"
#include "cpu/i386/i386.h"

static VIDEO_START(taitotx)
{
	return 0;
}

static VIDEO_UPDATE(taitotx)
{
}

static ADDRESS_MAP_START( taitotx_map, ADDRESS_SPACE_PROGRAM, 32 )
	AM_RANGE(0xff000000, 0xff7fffff) AM_ROM AM_REGION(REGION_USER2, 0)
	AM_RANGE(0xff800000, 0xff80ffff) AM_ROM AM_REGION(REGION_USER1, 0) //Security Dongle
ADDRESS_MAP_END

#define AT_KEYB_HELPER(bit, text, key1) \
	PORT_BIT( bit, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME(text) PORT_CODE(key1)

INPUT_PORTS_START(taitotx)

        PORT_START /* IN4? */
        PORT_BIT ( 0x0001, IP_ACTIVE_LOW, IPT_START1 )
        PORT_BIT ( 0x0002, IP_ACTIVE_LOW, IPT_START2 )
        PORT_BIT ( 0x0004, IP_ACTIVE_LOW, IPT_SERVICE1 )
        PORT_BIT ( 0x0008, IP_ACTIVE_LOW, IPT_SERVICE2 )
        PORT_BIT ( 0x0010, IP_ACTIVE_LOW, IPT_OTHER ) PORT_NAME("Test Switch") PORT_CODE(KEYCODE_F2)
        PORT_BIT ( 0x0100, IP_ACTIVE_LOW, IPT_SERVICE3 )
        PORT_BIT ( 0x0200, IP_ACTIVE_LOW, IPT_SERVICE4 )
        PORT_BIT ( 0x0400, IP_ACTIVE_LOW, IPT_START3 )
        PORT_BIT ( 0x0800, IP_ACTIVE_LOW, IPT_START4 )

         PORT_START /* IN0? */
        AT_KEYB_HELPER ( 0x0001, "A", KEYCODE_A)
        AT_KEYB_HELPER ( 0x0002, "B", KEYCODE_B)
        AT_KEYB_HELPER ( 0x0004, "C", KEYCODE_C)
        AT_KEYB_HELPER ( 0x0008, "D", KEYCODE_D)
        AT_KEYB_HELPER ( 0x0010, "E", KEYCODE_E)
        AT_KEYB_HELPER ( 0x0020, "F", KEYCODE_F)
        AT_KEYB_HELPER ( 0x0040, "G", KEYCODE_G)
        AT_KEYB_HELPER ( 0x0080, "H", KEYCODE_H)
        AT_KEYB_HELPER ( 0x0100, "I", KEYCODE_I)
        AT_KEYB_HELPER ( 0x0200, "J", KEYCODE_J)
        AT_KEYB_HELPER ( 0x0400, "K", KEYCODE_K)
        AT_KEYB_HELPER ( 0x0800, "L", KEYCODE_L)
        AT_KEYB_HELPER ( 0x1000, "M", KEYCODE_M)
        AT_KEYB_HELPER ( 0x2000, "N", KEYCODE_N)
        AT_KEYB_HELPER ( 0x4000, "O", KEYCODE_O)
        AT_KEYB_HELPER ( 0x8000, "P", KEYCODE_P)

       PORT_START /* IN1? */
        AT_KEYB_HELPER ( 0x0001, "Q", KEYCODE_Q)
        AT_KEYB_HELPER ( 0x0002, "R", KEYCODE_R)
        AT_KEYB_HELPER ( 0x0004, "S", KEYCODE_S)
        AT_KEYB_HELPER ( 0x0008, "T", KEYCODE_T)
        AT_KEYB_HELPER ( 0x0010, "U", KEYCODE_U)
        AT_KEYB_HELPER ( 0x0020, "V", KEYCODE_V)
        AT_KEYB_HELPER ( 0x0040, "W", KEYCODE_W)
        AT_KEYB_HELPER ( 0x0080, "X", KEYCODE_X)
        AT_KEYB_HELPER ( 0x0100, "Y", KEYCODE_Y)
        AT_KEYB_HELPER ( 0x0200, "Z", KEYCODE_Z)

        PORT_START /* IN2? */
        AT_KEYB_HELPER ( 0x0001, "DOWN", KEYCODE_DOWN)
        AT_KEYB_HELPER ( 0x0002, "UP", KEYCODE_UP)
        AT_KEYB_HELPER ( 0x0004, "LEFT", KEYCODE_LEFT)
        AT_KEYB_HELPER ( 0x0008, "RIGHT", KEYCODE_RIGHT)
        AT_KEYB_HELPER ( 0x0010, "ENTER", KEYCODE_ENTER)
        AT_KEYB_HELPER ( 0x0020, "BACKSPACE", KEYCODE_BACKSPACE)
        AT_KEYB_HELPER ( 0x0040, "ESC", KEYCODE_ESC)
        AT_KEYB_HELPER ( 0x0080, "TAB", KEYCODE_TAB)
        AT_KEYB_HELPER ( 0x0100, "0", KEYCODE_0)
        AT_KEYB_HELPER ( 0x0200, "1", KEYCODE_1)
        AT_KEYB_HELPER ( 0x0400, "2", KEYCODE_2)
        AT_KEYB_HELPER ( 0x0800, "3", KEYCODE_3)
        AT_KEYB_HELPER ( 0x1000, "4", KEYCODE_4)
        AT_KEYB_HELPER ( 0x2000, "5", KEYCODE_5)
        AT_KEYB_HELPER ( 0x4000, "6", KEYCODE_6)
        AT_KEYB_HELPER ( 0x8000, "7", KEYCODE_7)

        PORT_START /* IN3? */

        AT_KEYB_HELPER ( 0x0001, "8", KEYCODE_8)
        AT_KEYB_HELPER ( 0x0002, "9", KEYCODE_9)
        AT_KEYB_HELPER ( 0x0004, "F1", KEYCODE_F1)
        AT_KEYB_HELPER ( 0x0008, "F2", KEYCODE_F2)
        AT_KEYB_HELPER ( 0x0010, "F3", KEYCODE_F3)
        AT_KEYB_HELPER ( 0x0020, "F4", KEYCODE_F4)
        AT_KEYB_HELPER ( 0x0040, "F5", KEYCODE_F5)
        AT_KEYB_HELPER ( 0x0080, "F6", KEYCODE_F6)
        AT_KEYB_HELPER ( 0x0100, "F7", KEYCODE_F7)
        AT_KEYB_HELPER ( 0x0200, "F8", KEYCODE_F8)
        AT_KEYB_HELPER ( 0x0400, "F9", KEYCODE_F9)
        AT_KEYB_HELPER ( 0x0800, "F10", KEYCODE_F10)
        AT_KEYB_HELPER ( 0x1000, "F11", KEYCODE_F11)
        AT_KEYB_HELPER ( 0x2000, "F12", KEYCODE_F12)
        PORT_BIT ( 0x4000, IP_ACTIVE_LOW, IPT_COIN1 )
        PORT_BIT ( 0x8000, IP_ACTIVE_LOW, IPT_COIN2 )

INPUT_PORTS_END


INPUT_PORTS_START(kirarin)

        PORT_START /* IN4? */
        PORT_BIT ( 0x0001, IP_ACTIVE_LOW, IPT_START1 )
        PORT_BIT ( 0x0002, IP_ACTIVE_LOW, IPT_START2 )
        PORT_BIT ( 0x0004, IP_ACTIVE_LOW, IPT_SERVICE1 )
        PORT_BIT ( 0x0008, IP_ACTIVE_LOW, IPT_SERVICE2 )
        PORT_BIT ( 0x0010, IP_ACTIVE_LOW, IPT_OTHER ) PORT_NAME("Test Switch") PORT_CODE(KEYCODE_F2)
        PORT_BIT ( 0x0020, IP_ACTIVE_HIGH, IPT_BUTTON1 ) PORT_NAME("Blue") PORT_PLAYER(1)
        PORT_BIT ( 0x0040, IP_ACTIVE_HIGH, IPT_BUTTON2 ) PORT_NAME("Red") PORT_PLAYER(1)
        PORT_BIT ( 0x0080, IP_ACTIVE_HIGH, IPT_BUTTON3 ) PORT_NAME("Green") PORT_PLAYER(1)
        PORT_BIT ( 0x0100, IP_ACTIVE_LOW, IPT_SERVICE3 )
        PORT_BIT ( 0x0200, IP_ACTIVE_LOW, IPT_SERVICE4 )
        PORT_BIT ( 0x0400, IP_ACTIVE_LOW, IPT_START3 )
        PORT_BIT ( 0x0800, IP_ACTIVE_LOW, IPT_START4 )

         PORT_START /* IN0? */
        AT_KEYB_HELPER ( 0x0001, "A", KEYCODE_A)
        AT_KEYB_HELPER ( 0x0002, "B", KEYCODE_B)
        AT_KEYB_HELPER ( 0x0004, "C", KEYCODE_C)
        AT_KEYB_HELPER ( 0x0008, "D", KEYCODE_D)
        AT_KEYB_HELPER ( 0x0010, "E", KEYCODE_E)
        AT_KEYB_HELPER ( 0x0020, "F", KEYCODE_F)
        AT_KEYB_HELPER ( 0x0040, "G", KEYCODE_G)
        AT_KEYB_HELPER ( 0x0080, "H", KEYCODE_H)
        AT_KEYB_HELPER ( 0x0100, "I", KEYCODE_I)
        AT_KEYB_HELPER ( 0x0200, "J", KEYCODE_J)
        AT_KEYB_HELPER ( 0x0400, "K", KEYCODE_K)
        AT_KEYB_HELPER ( 0x0800, "L", KEYCODE_L)
        AT_KEYB_HELPER ( 0x1000, "M", KEYCODE_M)
        AT_KEYB_HELPER ( 0x2000, "N", KEYCODE_N)
        AT_KEYB_HELPER ( 0x4000, "O", KEYCODE_O)
        AT_KEYB_HELPER ( 0x8000, "P", KEYCODE_P)

       PORT_START /* IN1? */
        AT_KEYB_HELPER ( 0x0001, "Q", KEYCODE_Q)
        AT_KEYB_HELPER ( 0x0002, "R", KEYCODE_R)
        AT_KEYB_HELPER ( 0x0004, "S", KEYCODE_S)
        AT_KEYB_HELPER ( 0x0008, "T", KEYCODE_T)
        AT_KEYB_HELPER ( 0x0010, "U", KEYCODE_U)
        AT_KEYB_HELPER ( 0x0020, "V", KEYCODE_V)
        AT_KEYB_HELPER ( 0x0040, "W", KEYCODE_W)
        AT_KEYB_HELPER ( 0x0080, "X", KEYCODE_X)
        AT_KEYB_HELPER ( 0x0100, "Y", KEYCODE_Y)
        AT_KEYB_HELPER ( 0x0200, "Z", KEYCODE_Z)

        PORT_START /* IN2? */
        AT_KEYB_HELPER ( 0x0001, "DOWN", KEYCODE_DOWN)
        AT_KEYB_HELPER ( 0x0002, "UP", KEYCODE_UP)
        AT_KEYB_HELPER ( 0x0004, "LEFT", KEYCODE_LEFT)
        AT_KEYB_HELPER ( 0x0008, "RIGHT", KEYCODE_RIGHT)
        AT_KEYB_HELPER ( 0x0010, "ENTER", KEYCODE_ENTER)
        AT_KEYB_HELPER ( 0x0020, "BACKSPACE", KEYCODE_BACKSPACE)
        AT_KEYB_HELPER ( 0x0040, "ESC", KEYCODE_ESC)
        AT_KEYB_HELPER ( 0x0080, "TAB", KEYCODE_TAB)
        AT_KEYB_HELPER ( 0x0100, "0", KEYCODE_0)
        AT_KEYB_HELPER ( 0x0200, "1", KEYCODE_1)
        AT_KEYB_HELPER ( 0x0400, "2", KEYCODE_2)
        AT_KEYB_HELPER ( 0x0800, "3", KEYCODE_3)
        AT_KEYB_HELPER ( 0x1000, "4", KEYCODE_4)
        AT_KEYB_HELPER ( 0x2000, "5", KEYCODE_5)
        AT_KEYB_HELPER ( 0x4000, "6", KEYCODE_6)
        AT_KEYB_HELPER ( 0x8000, "7", KEYCODE_7)

        PORT_START /* IN3? */

        AT_KEYB_HELPER ( 0x0001, "8", KEYCODE_8)
        AT_KEYB_HELPER ( 0x0002, "9", KEYCODE_9)
        AT_KEYB_HELPER ( 0x0004, "F1", KEYCODE_F1)
        AT_KEYB_HELPER ( 0x0008, "F2", KEYCODE_F2)
        AT_KEYB_HELPER ( 0x0010, "F3", KEYCODE_F3)
        AT_KEYB_HELPER ( 0x0020, "F4", KEYCODE_F4)
        AT_KEYB_HELPER ( 0x0040, "F5", KEYCODE_F5)
        AT_KEYB_HELPER ( 0x0080, "F6", KEYCODE_F6)
        AT_KEYB_HELPER ( 0x0100, "F7", KEYCODE_F7)
        AT_KEYB_HELPER ( 0x0200, "F8", KEYCODE_F8)
        AT_KEYB_HELPER ( 0x0400, "F9", KEYCODE_F9)
        AT_KEYB_HELPER ( 0x0800, "F10", KEYCODE_F10)
        AT_KEYB_HELPER ( 0x1000, "F11", KEYCODE_F11)
        AT_KEYB_HELPER ( 0x2000, "F12", KEYCODE_F12)
        PORT_BIT ( 0x4000, IP_ACTIVE_LOW, IPT_COIN1 )
        PORT_BIT ( 0x8000, IP_ACTIVE_LOW, IPT_COIN2 )

INPUT_PORTS_END

INPUT_PORTS_START(tgm3j)

        PORT_START /* IN4? */
        PORT_BIT ( 0x0001, IP_ACTIVE_LOW, IPT_START1 )
        PORT_BIT ( 0x0002, IP_ACTIVE_LOW, IPT_START2 )
        PORT_BIT ( 0x0004, IP_ACTIVE_LOW, IPT_SERVICE1 )
        PORT_BIT ( 0x0008, IP_ACTIVE_LOW, IPT_SERVICE2 )
        PORT_BIT ( 0x0010, IP_ACTIVE_LOW, IPT_OTHER ) PORT_NAME("Test Switch") PORT_CODE(KEYCODE_F2)
        PORT_BIT ( 0x0020, IP_ACTIVE_HIGH, IPT_BUTTON1 ) PORT_PLAYER(1)
        PORT_BIT ( 0x0040, IP_ACTIVE_HIGH, IPT_BUTTON2 ) PORT_PLAYER(1)
        PORT_BIT ( 0x0080, IP_ACTIVE_HIGH, IPT_BUTTON3 ) PORT_PLAYER(1)
        PORT_BIT ( 0x0100, IP_ACTIVE_LOW, IPT_SERVICE3 )
        PORT_BIT ( 0x0200, IP_ACTIVE_LOW, IPT_SERVICE4 )
        PORT_BIT ( 0x0400, IP_ACTIVE_LOW, IPT_START3 )
        PORT_BIT ( 0x0800, IP_ACTIVE_LOW, IPT_START4 )
        PORT_BIT ( 0x1000, IP_ACTIVE_HIGH, IPT_BUTTON1 ) PORT_PLAYER(2)
        PORT_BIT ( 0x2000, IP_ACTIVE_HIGH, IPT_BUTTON2 ) PORT_PLAYER(2)
        PORT_BIT ( 0x4000, IP_ACTIVE_HIGH, IPT_BUTTON3 ) PORT_PLAYER(2)

         PORT_START /* IN0? */
        AT_KEYB_HELPER ( 0x0001, "A", KEYCODE_A)
        AT_KEYB_HELPER ( 0x0002, "B", KEYCODE_B)
        AT_KEYB_HELPER ( 0x0004, "C", KEYCODE_C)
        AT_KEYB_HELPER ( 0x0008, "D", KEYCODE_D)
        AT_KEYB_HELPER ( 0x0010, "E", KEYCODE_E)
        AT_KEYB_HELPER ( 0x0020, "F", KEYCODE_F)
        AT_KEYB_HELPER ( 0x0040, "G", KEYCODE_G)
        AT_KEYB_HELPER ( 0x0080, "H", KEYCODE_H)
        AT_KEYB_HELPER ( 0x0100, "I", KEYCODE_I)
        AT_KEYB_HELPER ( 0x0200, "J", KEYCODE_J)
        AT_KEYB_HELPER ( 0x0400, "K", KEYCODE_K)
        AT_KEYB_HELPER ( 0x0800, "L", KEYCODE_L)
        AT_KEYB_HELPER ( 0x1000, "M", KEYCODE_M)
        AT_KEYB_HELPER ( 0x2000, "N", KEYCODE_N)
        AT_KEYB_HELPER ( 0x4000, "O", KEYCODE_O)
        AT_KEYB_HELPER ( 0x8000, "P", KEYCODE_P)

       PORT_START /* IN1? */
        AT_KEYB_HELPER ( 0x0001, "Q", KEYCODE_Q)
        AT_KEYB_HELPER ( 0x0002, "R", KEYCODE_R)
        AT_KEYB_HELPER ( 0x0004, "S", KEYCODE_S)
        AT_KEYB_HELPER ( 0x0008, "T", KEYCODE_T)
        AT_KEYB_HELPER ( 0x0010, "U", KEYCODE_U)
        AT_KEYB_HELPER ( 0x0020, "V", KEYCODE_V)
        AT_KEYB_HELPER ( 0x0040, "W", KEYCODE_W)
        AT_KEYB_HELPER ( 0x0080, "X", KEYCODE_X)
        AT_KEYB_HELPER ( 0x0100, "Y", KEYCODE_Y)
        AT_KEYB_HELPER ( 0x0200, "Z", KEYCODE_Z)

        PORT_START /* IN2? */
        AT_KEYB_HELPER ( 0x0001, "DOWN", KEYCODE_DOWN)
        AT_KEYB_HELPER ( 0x0002, "UP", KEYCODE_UP)
        AT_KEYB_HELPER ( 0x0004, "LEFT", KEYCODE_LEFT)
        AT_KEYB_HELPER ( 0x0008, "RIGHT", KEYCODE_RIGHT)
        AT_KEYB_HELPER ( 0x0010, "ENTER", KEYCODE_ENTER)
        AT_KEYB_HELPER ( 0x0020, "BACKSPACE", KEYCODE_BACKSPACE)
        AT_KEYB_HELPER ( 0x0040, "ESC", KEYCODE_ESC)
        AT_KEYB_HELPER ( 0x0080, "TAB", KEYCODE_TAB)
        AT_KEYB_HELPER ( 0x0100, "0", KEYCODE_0)
        AT_KEYB_HELPER ( 0x0200, "1", KEYCODE_1)
        AT_KEYB_HELPER ( 0x0400, "2", KEYCODE_2)
        AT_KEYB_HELPER ( 0x0800, "3", KEYCODE_3)
        AT_KEYB_HELPER ( 0x1000, "4", KEYCODE_4)
        AT_KEYB_HELPER ( 0x2000, "5", KEYCODE_5)
        AT_KEYB_HELPER ( 0x4000, "6", KEYCODE_6)
        AT_KEYB_HELPER ( 0x8000, "7", KEYCODE_7)

        PORT_START /* IN3? */

        AT_KEYB_HELPER ( 0x0001, "8", KEYCODE_8)
        AT_KEYB_HELPER ( 0x0002, "9", KEYCODE_9)
        AT_KEYB_HELPER ( 0x0004, "F1", KEYCODE_F1)
        AT_KEYB_HELPER ( 0x0008, "F2", KEYCODE_F2)
        AT_KEYB_HELPER ( 0x0010, "F3", KEYCODE_F3)
        AT_KEYB_HELPER ( 0x0020, "F4", KEYCODE_F4)
        AT_KEYB_HELPER ( 0x0040, "F5", KEYCODE_F5)
        AT_KEYB_HELPER ( 0x0080, "F6", KEYCODE_F6)
        AT_KEYB_HELPER ( 0x0100, "F7", KEYCODE_F7)
        AT_KEYB_HELPER ( 0x0200, "F8", KEYCODE_F8)
        AT_KEYB_HELPER ( 0x0400, "F9", KEYCODE_F9)
        AT_KEYB_HELPER ( 0x0800, "F10", KEYCODE_F10)
        AT_KEYB_HELPER ( 0x1000, "F11", KEYCODE_F11)
        AT_KEYB_HELPER ( 0x2000, "F12", KEYCODE_F12)
        PORT_BIT ( 0x4000, IP_ACTIVE_LOW, IPT_COIN1 )
        PORT_BIT ( 0x8000, IP_ACTIVE_LOW, IPT_COIN2 )

INPUT_PORTS_END

static MACHINE_DRIVER_START(taitotx)

	/* basic machine hardware */
	MDRV_CPU_ADD(PENTIUM, 100000000)
	MDRV_CPU_PROGRAM_MAP(taitotx_map, 0)


	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(0)


 	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_RGB_DIRECT)
	MDRV_SCREEN_SIZE(1024, 768)
	MDRV_VISIBLE_AREA(0, 1023, 0, 767)
	MDRV_PALETTE_LENGTH(65536)

	MDRV_VIDEO_START(taitotx)
	MDRV_VIDEO_UPDATE(taitotx)

MACHINE_DRIVER_END

static MACHINE_DRIVER_START(taitotx2)

	/* basic machine hardware */
	MDRV_CPU_ADD(PENTIUM, 150000000)
	MDRV_CPU_PROGRAM_MAP(taitotx_map, 0)


	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(0)


 	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_RGB_DIRECT)
	MDRV_SCREEN_SIZE(1280, 960)
	MDRV_VISIBLE_AREA(0, 1279, 0, 959)
	MDRV_PALETTE_LENGTH(65536)

	MDRV_VIDEO_START(taitotx)
	MDRV_VIDEO_UPDATE(taitotx)

MACHINE_DRIVER_END

/* ROM */

#define TAITOTYPEX_BIOS	\
        ROM_LOAD( "taitotz1.bios", 0x000000, 0x200000, BAD_DUMP CRC(2b2e41a2) SHA1(f0a74bbcaf801f3fd0b7002ebd0118564aae3528) ) // type1 main bios

#define TAITOTYPEX2_BIOS	\
        ROM_LOAD( "taitotz2.bios", 0x000000, 0x200000, BAD_DUMP CRC(b2a8eeb6) SHA1(bc4fb4e1e53adbd92385f1726bd69663ff870f1e) ) // type2 main bios

ROM_START( taitotx )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

ROM_END

ROM_START( taitotx2 )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX2_BIOS

ROM_END

ROM_START( kirarihp )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirarihp.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirarihp.u2", 0x008000, 0x008000, NO_DUMP )


ROM_END

ROM_START( kirarih2 )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirarihp.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirarih2.u2", 0x008000, 0x008000, NO_DUMP )


ROM_END

ROM_START( kirarih3 )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirarihp.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirarih3.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

ROM_START( kirarih4 )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirarihp.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirarih4.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

ROM_START( kirarih5 )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirarihp.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirarih5.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

ROM_START( kirariki )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kirariki.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kirariki.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

ROM_START( tgm3j )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "tgm3j.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "tgm3j.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

ROM_START( kofxiii )
	ROM_REGION(0x800000, REGION_USER2, 0)
	TAITOTYPEX2_BIOS

	ROM_REGION(0x010000, REGION_USER1, 0)
        ROM_LOAD( "kofxiii.u1", 0x000000, 0x008000, NO_DUMP )
        ROM_LOAD( "kofxiii.u2", 0x008000, 0x008000, NO_DUMP )

ROM_END

/* Game Drivers */

/* Type-X */
GAME(2004, taitotx,          0, taitotx, taitotx, 0, ROT0, "Taito", "Taito Type-X BIOS", GAME_NO_SOUND|GAME_NOT_WORKING|NOT_A_DRIVER)

GAME(2006, kirarihp,          taitotx, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Happy Idol Life 1st Stage", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2007, kirarih2,          kirarihp, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Happy Idol Life 2nd Stage", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2007, kirarih3,          kirarihp, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Happy Idol Life 3rd Stage", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2007, kirarih4,          kirarihp, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Happy Idol Life 4th Stage", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2007, kirarih5,          kirarihp, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Happy Idol Life 5th Stage", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2008, kirariki,          taitotx, taitotx, kirarin, 0, ROT0, "Atlus", "Kirarin Revolution Kurukira Idol Days", GAME_NO_SOUND|GAME_NOT_WORKING)
GAME(2005, tgm3j,          taitotx, taitotx, tgm3j, 0, ROT0, "Taito / Psikyo", "Tetris The Grand Master 3", GAME_NO_SOUND|GAME_NOT_WORKING)

/* Type-X2 */
GAME(2004, taitotx2,          0, taitotx2, taitotx, 0, ROT0, "Taito", "Taito Type-X2 BIOS", GAME_NO_SOUND|GAME_NOT_WORKING|NOT_A_DRIVER)

GAME(2010, kofxiii,          taitotx2, taitotx2, taitotx, 0, ROT0, "SNK Playmore", "The King of Fighters XIII", GAME_NO_SOUND|GAME_NOT_WORKING)
