#include	"trust.h"
#include	"shm.h"

void	exit (int status);

void	MainLoop();
void	CloseSocket();
void	CloseChild();

void main(argc, argv)
int	argc;
char	*argv[];
{

	Soc = 0;
	Acc = 0;
	TrustDB_in = 0;
	TrustDB_out = 0;

	InitSocket();
	InitSignal();
	MainLoop();
}

int InitSocket(void)
{
	char	hostname[MAXHOSTNAMELEN];
	struct	hostent	*myhost;
	struct	servent	*se;
	struct	sockaddr_in	me;
	int	opt;

	DB(fprintf(stderr,"InitSocket\n"));

	if (gethostname(hostname,MAXHOSTNAMELEN) == -1){
		perror("gethostname");
		exit(-1);
	}
	DB(fprintf(stderr,"hostname=%s\n",hostname));
	if ((se=getservbyname("AuthTrust","tcp")) == NULL){
		perror("getservbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"getservbyname:OK\n"));
	if ((myhost=gethostbyname(hostname)) == NULL){
		perror("gethostbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"gethostbyname:OK\n"));
	if ((Soc=socket(AF_INET,SOCK_STREAM,0)) < 0){
		perror("socket");
		exit(-1);
	}
	DB(fprintf(stderr,"socket:OK\n"));
	opt=1;
	if (setsockopt(Soc,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
		perror("setsockopt");
		exit(-1);
	}
	DB(fprintf(stderr,"setsockopt:OK\n"));
        memset((char *)&me,0,sizeof(me));
        me.sin_family=AF_INET;
        me.sin_port=se->s_port;
        if (bind(Soc,(struct sockaddr *)&me,sizeof(me)) == -1){
                perror("bind");
                exit(-1);
        }
        DB(fprintf(stderr,"bind:OK\n"));
        if ((se=getservbyname("TrustDB_in","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_in:OK\n"));
        if ((TrustDB_in=socket(AF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_in");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_in:OK\n"));

	memset((char *)&db,0,sizeof(db));
	db.sin_family=AF_INET;
	db.sin_port=se->s_port;
	if (bind(TrustDB_in,(struct sockaddr *)&db,sizeof(db)) == -1){
		perror("bind:db");
		exit(-1);
	}
	DB(fprintf(stderr,"bind:db:OK\n"));

        if ((se=getservbyname("TrustDB_out","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_out:OK\n"));
	dbInPort = se->s_port;

        shm_id = shmget (IPC_PRIVATE, sizeof(struct shm_form) * MAX_SHM ,
				IPC_CREAT | 0660);
	if (shm_id == -1)
        {
                perror("shmget");
                exit(-1);
        }
	DB(fprintf(stderr,"shmget:OK\n"));

	shm_msg = shmat (shm_id, NULL, 0);
	if (shm_msg == (void *)-1)
	{
		perror("shmat");
		shmctl (shm_id, IPC_RMID, NULL);
		exit(-1);
	}
        DB(fprintf(stderr,"shmat:OK\n"));

	return(0);
}

void CloseSocket()
{
	DB(fprintf(stderr,"CloseSocket\n"));
	if(Soc != 0){
		close(Soc);
		DB(fprintf(stderr,"close(Soc)\n"));
		Soc = 0;
	}
	if(Acc != 0){
		close(Acc);
		DB(fprintf(stderr,"close(Acc)\n"));
		Acc = 0;
	}
        if(TrustDB_in != 0){
                close(TrustDB_in);
                DB(fprintf(stderr,"close(TrustDB_in)\n"));
                TrustDB_in = 0;
        }
        if(TrustDB_out != 0){
                close(TrustDB_out);
                DB(fprintf(stderr,"close(TrustDB_out)\n"));
                TrustDB_out = 0;
        }
	DB(fprintf(stderr,"CloseSocket:exit\n"));

        shmdt (shm_msg);
        shmctl (shm_id, IPC_RMID, NULL);

	exit(0);
}

void CloseChild()
{
	int	pid;

	DB(fprintf(stderr,"CloseChild\n"));
	pid=wait(0);
	DB(fprintf(stderr,"wait:pid=%d:end\n",pid));
	signal(SIGCLD,CloseChild);
}

int InitSignal()
{
	DB(fprintf(stderr,"InitSignal\n"));
	signal(SIGINT,CloseSocket);
	signal(SIGTERM,CloseSocket);
	signal(SIGCLD,CloseChild);

	return(0);
}

void MainLoop(void)
{
	struct sockaddr_in	from;
	int	n;
	int	len,width, pid;
	fd_set	readOk,Mask;
	struct	timeval	timeout;
	char	client[64];

	DB(fprintf(stderr,"MainLoop\n"));

	for (n = 0 ; n < MAX_SHM ; n++)
	{
		shm_msg->shmem[n].type = 0;
		shm_msg->shmem[n].protocol = 0;
		shm_msg->shmem[n].e_time.tv_sec = 0;
		shm_msg->shmem[n].e_time.tv_usec = 0;
		memset (shm_msg->shmem[n].srcCall, 0x20, 8); 
		memset (shm_msg->shmem[n].dstCall, 0x20, 8);
	}

	width=0;
	FD_ZERO(&Mask);
	FD_SET(Soc, &Mask);
	FD_SET(TrustDB_in, &Mask);
	FD_SET(0, &Mask);
	width = Soc;
	if (width < TrustDB_in) width = TrustDB_in;
	width += 1;

	listen(Soc,SOMAXCONN);
	DB(fprintf(stderr,"listen:OK\n"));
	while(1){
		readOk = Mask;
		timeout.tv_sec = 0;
		timeout.tv_usec = 500000;
		switch (select(width, (fd_set *)&readOk, NULL, NULL, &timeout)){
			case	-1:
				perror("select");
				break;
			case	0:
				DeleteEntry();
				break;
			default:
				if(FD_ISSET(Soc,&readOk)){
					len=sizeof(from);
					Acc=accept(Soc, (struct sockaddr *)&from,&len);
					if(Acc<0){
						if(errno==EINTR){
							continue;
						}
						perror("accept");
						continue;
					}
					sprintf(client,"%s", inet_ntoa (from.sin_addr));
					DB(fprintf(stderr,"accept:%s\n",client));
					RepeaterIP = from.sin_addr;
					if((pid=fork())==0){
						close(Soc);
						Soc=0;
						Repeater();
						DB(fprintf(stderr,"MainLoop:exit\n"));
						exit(0);
					}
					DB(fprintf(stderr,"pid=%d\n",pid));
					setpgrp(pid, getpid());
					close(Acc);
					Acc=0;
				}
				if (FD_ISSET(TrustDB_in, &readOk)) {
					insEntry();
				}
				if(FD_ISSET(0,&readOk)){
					KeyIn();
				}
				break;
		}
	}
}

int KeyIn(void)
{
	char	buf[128];

	fgets(buf, sizeof(buf), stdin);

	DoKeyInCommand(buf);

	return(0);
}

int DoKeyInCommand(char *str)
{
	int	k, n;

	k = strlen(str);
	for (n = 0 ; n < k ; n++)
	{	
		if (str[n] == 0x0a) str[n] = 0x00;
		if (str[n] == 0x0d) str[n] = 0x00;
	}

	DB(fprintf(stderr,"(%s)\n",str));

	if (strlen(str))
	{
		if((strncmp(str,"end", strlen(str))==0) || strncmp(str, "exit", strlen(str)) == 0){
			killpg(getpid(),SIGTERM);
			CloseSocket();
			return(1);
		}
	}

	return(0);
}

