/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.statement;

import net.morilib.awk.AwkBreakException;
import net.morilib.awk.AwkContinueException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkWhile extends AwkExpression {

	private AwkExpression cond, stmt;

	/**
	 * 
	 * @param cond
	 * @param stmt
	 */
	public AwkWhile(AwkExpression cond, AwkExpression stmt) {
		this.cond = cond;
		this.stmt = stmt;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue v = AwkUndefined.UNDEF;

		try {
			while(cond.eval(ns, o).toBoolean()) {
				try {
					v = stmt.eval(ns, o);
				} catch(AwkContinueException e) {}
			}
		} catch(AwkBreakException e) {}
		return v;
	}

	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object l1 = new Object(), l2 = new Object();

		b.addLabel(l1);
		b.add(cond);
		b.addJmpZ(l2);
		stmt.compileInternally(b, l2, l1);
		b.addJmp(l1);
		b.addLabel(l2);
	}

}
