/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.charset;

/**
 * Constant objects and utilities for character sets
 * implemented by the Range library.
 * <p>Rangeライブラリにより実装された文字セットの定数オブジェクトと
 * ユーティリティである.
 * 
 * @author MORIGUCHI, Yuichiro 2008/01/01
 */
public final class UnixCharSets {

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/10/09
	 */
	public interface CharSetHandler {

		/**
		 * 
		 * @param ch
		 */
		public void singleChar(int ch);

		/**
		 * 
		 * @param cb
		 * @param ce
		 */
		public void rangedChar(int cb, int ce);

	}

	//
	private UnixCharSets() {}

	/**
	 * 
	 */
	public static final IntInterval ALL_CHAR =
		new IntInterval(0, Character.MAX_VALUE);

	//
	private static IntInterval getintv(int ch, int ch2) {
		return new IntInterval(ch, ch2);
	}

	//
	static boolean parse(
			CharSequence s, CharSetHandler h) {
		StringBuilder b = new StringBuilder();
		int st = 1;
		int c, cb = -1, pt = 0;

		while(pt < s.length()) {
			c = s.charAt(pt++);
			if(st == 1) {
				if(c == '\\') {
					st = 2;
				} else {
					cb = c;  st = 4;
				}
			} else if(st == 2) {
				switch(c) {
				case 'x':
				case 'u':   st = 3;  break;
				case '\\':  cb = c;  st = 4;  break;
				case 't':   cb = '\t';  st = 4;  break;
				case 'n':   cb = '\n';  st = 4;  break;
				case 'r':   cb = '\r';  st = 4;  break;
				default:   return false;
				}
			} else if(st == 3) {
				if(pt + 2 >= s.length()) {
					return false;
				}
				b.append((char)c);
				b.append(s.charAt(pt++));
				b.append(s.charAt(pt++));
				b.append(s.charAt(pt++));
				try {
					cb = Integer.parseInt(b.toString(), 16);
					b.delete(0, b.length());
					st = 4;
				} catch(NumberFormatException e) {
					throw new RuntimeException("Illegal code");
				}
			} else if(st == 4) {
				if(c == '\\') {
					h.singleChar(cb);
					st = 2;
				} else if(c == '-') {
					st = 5;
				} else {
					h.singleChar(cb);
					cb = c;  st = 4;
				}
			} else if(st == 5) {
				if(c == '\\') {
					st = 6;
				} else {
					if(c < cb) {
						return false;
					}
					h.rangedChar(cb, c);
					st = 1;
				}
			} else if(st == 6) {
				switch(c) {
				case 'x':
				case 'u':   st = 7;  break;
				case '\\':  break;
				case 't':   c = '\t';  break;
				case 'n':   c = '\n';  break;
				case 'r':   c = '\r';  break;
				default:   return false;
				}

				if(c < cb) {
					return false;
				}
				h.rangedChar(cb, c);
				st = 1;
			} else if(st == 7) {
				if(pt + 2 >= s.length()) {
					return false;
				}
				b.append((char)c);
				b.append(s.charAt(pt++));
				b.append(s.charAt(pt++));
				b.append(s.charAt(pt++));
				try {
					int cz = Integer.parseInt(b.toString(), 16);

					if(cz < cb) {
						return false;
					}
					h.rangedChar(cb, cz);
					b.delete(0, b.length());
					st = 1;
				} catch(NumberFormatException e) {
					throw new RuntimeException("Illegal code");
				}
			}
		}

		if(st == 4) {
			h.singleChar(cb);
		}
		return true;
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static IntRange parse(CharSequence s) {
		boolean r;
		final IntRange[] ra = new IntRange[1];

		ra[0] = IntRange.O;
		r = UnixCharSets.parse(s, new CharSetHandler() {

			public void singleChar(int ch) {
				ra[0] = ra[0].join(getintv(ch, ch));
			}

			public void rangedChar(int cb, int ce) {
				ra[0] = ra[0].join(getintv(cb, ce));
			}

		});

		if(!r) {
			throw new UnixCharSetException();
		}
		return ra[0];
	}

}
