/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import net.morilib.awk.value.AwkValue;

public final class AwkStatUtils {

	/**
	 * 
	 * @param a
	 * @return
	 */
	public static double[] toDoubleArray(AwkValue a) {
		List<Double> v;
		double[] x;
		int j = 0;

		v = new ArrayList<Double>();
		for(int i = 1; a.referArray(i + "").isRealValue(); i++) {
			v.add(a.referArray(i + "").toFloat());
		}
		x = new double[v.size()];  j = 0;
		for(double d : v)  x[j++] = d;
		return x;
	}

	/**
	 * 
	 * @param a
	 * @return
	 */
	public static double[] toDoubleValues(AwkValue a) {
		Collection<AwkValue> z;
		List<Double> v;
		double[] x;
		int j = 0;

		z = a.values();
		v = new ArrayList<Double>();
		for(AwkValue b : z) {
			if(b.isRealValue())  v.add(b.toFloat());
		}
		x = new double[v.size()];  j = 0;
		for(double d : v)  x[j++] = d;
		return x;
	}

}
