/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleMatrices;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkValue;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/31
 */
public class MatSolve extends AwkBinaryArgs {

	/**
	 * @param name
	 */
	protected MatSolve() {
		super("solve");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.builtin.AwkBinaryArgs#apply(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, net.morilib.awk.value.AwkValue, net.morilib.awk.value.AwkValue)
	 */
	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		DoubleMatrix a;
		DoubleVector v, r;
		String sep;

		sep = ns.getRoot().find(AwkMatrices.SUBSEP).toString(ns);
		if(!a1.isArray()) {
			throw new AwkMatrixException("matrix required");
		} else if((a = AwkMatrices.toDoubleMatrix2(a1, sep)) == null) {
			throw new AwkMatrixException("matrix required");
		} else {
			v = AwkMatrices.toDoubleVector(a2);
			r = DoubleMatrices.solve(a, v);
			return AwkMatrices.toAwkArray(r);
		}
	}

}
