/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.HashMap;
import java.util.Map;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class Count extends AwkUnaryArgs {

	public Count() {
		super("count");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		AwkArray ar = new AwkArray();
		Map<String, Long> m;
		String s;

		if(a1 instanceof AwkArray) {
			m = new HashMap<String, Long>();
			for(AwkValue v : a1.values()) {
				s = v.toString(ns);
				if(m.containsKey(s)) {
					m.put(s, m.get(s) + 1l);
				} else {
					m.put(s, 1l);
				}
			}

			for(Map.Entry<String, Long> e : m.entrySet()) {
				ar.putArray(e.getKey(),
						AwkInteger.valueOf(e.getValue()));
			}
		} else {
			ar.putArray(a1.toString(ns), AwkInteger.ONE);
		}
		return ar;
	}

}
