/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.dist.discrete.BinomialDistribution;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkValue;

public class DistBinomial extends AwkTernaryArgs {

	protected DistBinomial() {
		super("distBinomial");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		double r;

		try {
			r = new BinomialDistribution(a2.toInteger(),
					a3.toFloat()).f(a1.toIntExact());
		} catch(IllegalArgumentException e) {
			throw new AwkStatisticsException("Illegal parameter");
		}
		return AwkFloat.valueOf(r);
	}

}
