/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.util;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.Tr;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/02
 */
public class UtilTr extends AwkTernaryArgs {

	/**
	 * @param name
	 */
	protected UtilTr() {
		super("tr");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.builtin.AwkTernaryArgs#apply(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, net.morilib.awk.value.AwkValue, net.morilib.awk.value.AwkValue, net.morilib.awk.value.AwkValue)
	 */
	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		String be, af, s;

		be = a1.toString(ns);
		af = a2.toString(ns);
		s  = a3 instanceof AwkUndefined ?
				ns.referField(0).toString(ns) : a3.toString(ns);
		s  = Tr.tr(be, af, s);
		return AwkString.valueOf(s);
	}

}
