/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;

import junit.framework.TestCase;

public class AwkCommandLineTest extends TestCase {

	PipedWriter pow, pew;
	PipedReader pir;
	PrintWriter piw;
	BufferedReader por, per;

	protected void setUp() {
		try {
			pir = new PipedReader();
			pow = new PipedWriter();
			pew = new PipedWriter();
			piw = new PrintWriter(new PipedWriter(pir));
			por = new BufferedReader(new PipedReader(pow));
			per = new BufferedReader(new PipedReader(pew));
		} catch(IOException e) {
			fail();
		}
	}

	void eot(String s) {
		try {
			if(!por.ready())  fail();
			assertEquals(por.readLine(), s);
		} catch (IOException e) {
			fail();
		}
	}

	void eet(String s) {
		try {
			if(!per.ready())  fail();
			assertEquals(per.readLine(), s);
		} catch (IOException e) {
			fail();
		}
	}

	void eot() {
		try {
			if(por.ready())  assertNull(por.readLine());
		} catch (IOException e) {
			fail();
		}
	}

	void eet() {
		try {
			if(per.ready())  assertNull(per.readLine());
		} catch (IOException e) {
			fail();
		}
	}

	void invoke(String... a) {
		try {
			Awk.getInstance().invoke(pir, pow, pew, a);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void testCommand001() {
		piw.println("aaaa bbb");
		piw.println("bbbb ccc");
		piw.close();
		invoke("awk", "{ print $1 }");
		eot("aaaa");
		eot("bbbb");
	}

	public void testCommand002() {
		piw.println("aaaa,bbb");
		piw.println("bbbb,ccc");
		piw.close();
		invoke("awk", "-F", ",", "{ print $1 }");
		eot("aaaa");
		eot("bbbb");
	}

	public void testCommand003() {
		piw.println("aaaa,bbb");
		piw.println("bbbb,ccc");
		piw.close();
		invoke("awk", "-F,", "{ print $1 }");
		eot("aaaa");
		eot("bbbb");
	}

	public void testCommand004() {
		piw.println("aaaa bbb");
		piw.println("bbbb ccc");
		piw.close();
		invoke("awk", "{ print v, $1 }", "v=a");
		eot("a aaaa");
		eot("a bbbb");
	}

	public void testCommand005() {
		piw.println("aaaa,bbb");
		piw.println("bbbb,ccc");
		piw.close();
		invoke("awk", "-F,", "{ print v, $1 }", "v=a");
		eot("a aaaa");
		eot("a bbbb");
	}

	public void testCommand006() {
		piw.println("aaaa,bbb");
		piw.println("bbbb,ccc");
		piw.close();
		invoke("awk", "{ print v, $1 }", "-F,", "v=a");
		eot("a aaaa");
		eot("a bbbb");
	}

	public void testCommand007() {
		piw.println("aaaa,bbb");
		piw.close();
		invoke("awk", "{ print ARGC, ARGV[0], ARGV[1] }", "v=a");
		eot("2 awk v=a");
	}

	public void testCommand008() {
		piw.println("aaaa,bbb");
		piw.close();
		invoke("awk", "BEGIN { print ARGC, ARGV[0], ARGV[1] }", "v=a");
		eot("2 awk v=a");
	}

	public void testCommand009() {
		piw.println("aaaa bbb");
		piw.println("bbbb ccc");
		piw.close();
		invoke("awk", "-F", "", "{ print $1 }");
		eot("aaaa bbb");
		eot("bbbb ccc");
	}

	public void testCommand010() {
		piw.println("aaaa bbb");
		piw.println("bbbb ccc");
		piw.close();
		invoke("awk", "-F", "", "{ print }");
		eot("aaaa bbb");
		eot("bbbb ccc");
	}

}
