/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.b;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

import net.morilib.awk.misc.Endianness;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * パッケージbを読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/27
 */
public class AwkBBuiltInLoader {

	/**
	 * 
	 * @param ns
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("b");

		ss.bindFunction("at",          new BAt());
		ss.bindFunction("c",           new BC());
		ss.bindFunction("intat",       new BIntat());
		ss.bindFunction("intatb",      new BIntatb());
		ss.bindFunction("intatl",      new BIntatl());
		ss.bindFunction("longat",      new BLongat());
		ss.bindFunction("longatb",     new BLongatb());
		ss.bindFunction("longatl",     new BLongatl());
		ss.bindFunction("shortat",     new BShortat());
		ss.bindFunction("shortatb",    new BShortatb());
		ss.bindFunction("shortatl",    new BShortatl());
		ss.bindFunction("tostring",    new BTostring());
		ss.bindFunction("uat",         new BUat());
		ss.bindFunction("uintat",      new BUintat());
		ss.bindFunction("uintatb",     new BUintatb());
		ss.bindFunction("uintatl",     new BUintatl());
		ss.bindFunction("ushortat",    new BUshortat());
		ss.bindFunction("ushortatb",   new BUshortatb());
		ss.bindFunction("ushortatl",   new BUshortatl());
		ss.bindFunction("write",       new BWrite());
		ss.bindFunction("writebyte",   new BWritebyte());
		ss.bindFunction("writeint",    new BWriteint());
		ss.bindFunction("writeintb",   new BWriteintb());
		ss.bindFunction("writeintl",   new BWriteintl());
		ss.bindFunction("writelong",   new BWritelong());
		ss.bindFunction("writelongb",  new BWritelongb());
		ss.bindFunction("writelongl",  new BWritelongl());
		ss.bindFunction("writeshort",  new BWriteshort());
		ss.bindFunction("writeshortb", new BWriteshortb());
		ss.bindFunction("writeshortl", new BWriteshortl());
	}

	//
	static Endianness endian(AwkValue v) {
		String s = v.toString();

		if(s.equalsIgnoreCase("little")) {
			return Endianness.LITTLE;
		} else if(s.equalsIgnoreCase("big")) {
			return Endianness.BIG;
		} else {
			return Endianness.nativeEndianness();
		}
	}

	//
	static Charset charset(AwkValue v) {
		if(v instanceof AwkUndefined) {
			return Charset.defaultCharset();
		} else {
			try {
				return Charset.forName(v.toString());
			} catch(UnsupportedCharsetException e) {
				return Charset.defaultCharset();
			}
		}
	}

	//
	static int index(AwkValue v) {
		return v instanceof AwkUndefined ? 0 : v.toIntExact();
	}

}
