/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数s.joinの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class SJoin extends AwkBinaryArgs {

	protected SJoin() {
		super("join");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		StringBuffer b = null;
		String d, f = "";

		d = a2 instanceof AwkUndefined ? ns.getOFS() : a2.toString(ns);
		if(a1.isArray()) {
			b = new StringBuffer();
			for(int i = 1;; i++) {
				if(!a1.contains(i + ""))  break;
				b.append(f).append(a1.referArray(i + "").toString(ns));
				f = d;
			}
			return AwkString.valueOf(b.toString());
		} else {
			return AwkUndefined.UNDEF;
		}
	}

}
