/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import net.morilib.awk.code.AwkExecutable;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/26
 */
public class ExtendAwkATest extends AwkTestCase {

	public void testAAddall01() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a.addall(a, b)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"], a[\"d\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"d\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a.addall(a, b, c)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"], a[\"d\"], a[\"e\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.addall(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.addall(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a.addall()\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("4 1 1 1 2");
		eot("5 1 1 1 2 3");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
	}

	public void testAAny() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  print a.any(a)" +
				"}" +
				"NR == 2 {" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  print a.any(a)" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  print a.any(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1");
		eot("0");
		eot("0");
	}

	public void testAContainKeys() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.containkeys(a, b)" +
				"}" +
				"NR == 2 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  b[\"d\"] = 1\n" +
				"  print a.containkeys(a, b)" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"b\"] = 0\n" +
				"  print a.containkeys(a, b, c)" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"a\"] = 0\n" +
				"  print a.containkeys(a, b, c)" +
				"}" +
				"NR == 5 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  print a.containkeys(a)" +
				"}" +
				"NR == 6 {" +
				"  print a.containkeys()" +
				"}" +
				"NR == 7 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.containkeys(a, b, 1)" +
				"}" +
				"NR == 8 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  b[\"d\"] = 1\n" +
				"  print a.containkeys(a, b)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1");
		eot("0");
		eot("1");
		eot("0");
		eot("1");
		eot("1");
		eot("0");
		eot("0");
	}

	public void testACopy() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b = a.copy(a)\n" +
				"  b[\"a\"] = 1\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]\n" +
				"  print a.size(b), b[\"a\"], b[\"b\"], b[\"c\"]\n" +
				"}" +
				"NR == 2 {" +
				"  c = a.copy(2)\n" +
				"  print a.size(c), c[1]" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("3 0 0 1");
		eot("3 1 0 1");
		eot("1 2");
	}

	public void testAEqualKeys() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.equalkeys(a, b)" +
				"}" +
				"NR == 2 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.equalkeys(a, b)" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  b[\"d\"] = 1\n" +
				"  print a.equalkeys(a, b)" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"a\"] = 0\n" +
				"  c[\"b\"] = 0\n" +
				"  c[\"c\"] = 1\n" +
				"  print a.equalkeys(a, b, c)" +
				"}" +
				"NR == 5 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  print a.equalkeys(a)" +
				"}" +
				"NR == 6 {" +
				"  print a.equalkeys()" +
				"}" +
				"NR == 7 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.containkeys(a, b, 1)" +
				"}" +
				"NR == 8 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"b\"] = 0\n" +
				"  c[\"c\"] = 1\n" +
				"  print a.equalkeys(a, b, c)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1");
		eot("0");
		eot("0");
		eot("1");
		eot("1");
		eot("1");
		eot("0");
		eot("0");
	}

	public void testAEquals() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.equals(a, b)" +
				"}" +
				"NR == 2 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.equals(a, b)" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a);  a.clear(b)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 0\n" +
				"  print a.equals(a, b)" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"a\"] = 0\n" +
				"  c[\"b\"] = 0\n" +
				"  c[\"c\"] = 1\n" +
				"  print a.equals(a, b, c)" +
				"}" +
				"NR == 5 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  print a.equals(a)" +
				"}" +
				"NR == 6 {" +
				"  print a.equals()" +
				"}" +
				"NR == 7 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  print a.equals(a, b, 1)" +
				"}" +
				"NR == 8 {" +
				"  a.clear(a);  a.clear(b);  a.clear(c)\n" +
				"  a[\"a\"] = 0\n" +
				"  a[\"b\"] = 0\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"a\"] = 0\n" +
				"  b[\"b\"] = 0\n" +
				"  b[\"c\"] = 1\n" +
				"  c[\"a\"] = 1\n" +
				"  c[\"b\"] = 0\n" +
				"  c[\"c\"] = 1\n" +
				"  print a.equals(a, b, c)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1");
		eot("0");
		eot("0");
		eot("1");
		eot("1");
		eot("1");
		eot("0");
		eot("0");
	}

	public void testAEvery() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  print a.every(a)" +
				"}" +
				"NR == 2 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 0\n" +
				"  print a.every(a)" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  print a.every(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1");
		eot("0");
		eot("1");
	}

	public void testAExcept() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a = a.except(a, b)\n" +
				"  print a.size(a), a[\"a\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"c\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a = a.except(a, b, c)\n" +
				"  print a.size(a), a[\"a\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.except(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.except(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a = a.except()\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1 1");
		eot("1 1");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
	}

	public void testAIntersect() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a = a.intersect(a, b)\n" +
				"  print a.size(a), a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"b\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a = a.intersect(a, b, c)\n" +
				"  print a.size(a), a[\"b\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.intersect(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.intersect(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a.intersect()\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("2 1 1");
		eot("1 1");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
	}

	public void testAIota() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a = a.iota(4, 7)\n" +
				"  print a.size(a), a[1], a[2], a[3], a[4]" +
				"}" +
				"NR == 2 {" +
				"  a = a.iota(7, 4)\n" +
				"  print a.size(a), a[1], a[2], a[3], a[4]" +
				"}" +
				"NR == 3 {" +
				"  a = a.iota(4, 4)\n" +
				"  print a.size(a), a[1]" +
				"}" +
				"NR == 4 {" +
				"  a = a.iota()\n" +
				"  print a.size(a), a[1]" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("4 4 5 6 7");
		eot("4 7 6 5 4");
		eot("1 4");
		eot("1 0");
	}

	public void testAMember() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a = a.iota(4, 7)\n" +
				"  print a.member(a, \"4\")\n" +
				"  print a.member(a, \"7\")\n" +
				"  print a.member(a, \"3\")\n" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		eot("1");
		eot("1");
		eot("0");
	}

	public void testARemoveall() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a.removeall(a, b)\n" +
				"  print a.size(a), a[\"a\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"c\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a.removeall(a, b, c)\n" +
				"  print a.size(a), a[\"a\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.removeall(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.removeall(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a = a.except()\n" +
				"  print a.size(a)" +
				"}" +
				"NR == 6 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  b[\"a\"] = 2\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  a.removeall(a, b)\n" +
				"  print a.size(a)" +
				"}" +
				"NR == 7 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  b[\"a\"] = 2\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  c[\"a\"] = 1\n" +
				"  a.removeall(a, b, c)\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("1 1");
		eot("1 1");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
		eot("0");
		eot("0");
	}

	public void testARetainall() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a.retainall(a, b)\n" +
				"  print a.size(a), a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"b\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a.retainall(a, b, c)\n" +
				"  print a.size(a), a[\"b\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.retainall(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a.retainall(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a.retainall()\n" +
				"  print a.size(a)" +
				"}" +
				"NR == 6 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  b[\"a\"] = 2\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  a.removeall(a, b)\n" +
				"  print a.size(a)" +
				"}" +
				"NR == 7 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  b[\"a\"] = 2\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  c[\"a\"] = 1\n" +
				"  a.removeall(a, b, c)\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("2 1 1");
		eot("1 1");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
		eot("0");
		eot("0");
	}

	public void testAUnion() {
		AwkExecutable e = pre("" +
				"NR == 1 {" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  a = a.union(a, b)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"], a[\"d\"]" +
				"}" +
				"NR == 2 {\n" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  b[\"b\"] = 2\n" +
				"  b[\"c\"] = 2\n" +
				"  b[\"d\"] = 2\n" +
				"  c[\"d\"] = 3\n" +
				"  c[\"e\"] = 3\n" +
				"  a = a.union(a, b, c)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"], a[\"d\"], a[\"e\"]" +
				"}" +
				"NR == 3 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.union(a)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 4 {" +
				"  a.clear(a)\n" +
				"  a[\"a\"] = 1\n" +
				"  a[\"b\"] = 1\n" +
				"  a[\"c\"] = 1\n" +
				"  a = a.union(a, 1)\n" +
				"  print a.size(a), a[\"a\"], a[\"b\"], a[\"c\"]" +
				"}" +
				"NR == 5 {" +
				"  a = a.union()\n" +
				"  print a.size(a)" +
				"}" +
				"");

		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		e.execute(ns0, fs0, "");
		eot("4 1 1 1 2");
		eot("5 1 1 1 2 3");
		eot("3 1 1 1");
		eot("3 1 1 1");
		eot("0");
	}

}
