/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.List;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 2つの引数を持つ関数の基底クラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public abstract class AwkBinaryArgs extends AwkFunction {

	/**
	 * 関数を生成します。
	 * 
	 * @param name 関数名
	 */
	protected AwkBinaryArgs(String name) {
		super(name, null);
	}

	/**
	 * 関数を適用します。
	 * 
	 * @param ns 名前空間
	 * @param o  ファイル管理
	 * @param a1 引数1
	 * @param a2 引数2
	 * @return 結果
	 */
	public abstract AwkValue apply(AwkNamespace ns, AwkFiles o,
			AwkValue a1, AwkValue a2);

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		AwkValue v1, v2;

		v1 = args.size() < 1 ? AwkUndefined.UNDEF : args.get(0);
		v2 = args.size() < 2 ? AwkUndefined.UNDEF : args.get(1);
		return apply(ns, o, v1, v2);
	}

}
