/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 組み込み関数matchの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkMatch extends AwkFunction {

	/**
	 * 
	 */
	public AwkMatch() {
		super("match", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		AwkValue v;
		Pattern r;
		Matcher m;
		String s;

		if(args.size() < 2) {
			return AwkInteger.ONE;
		} else {
			r = args.get(1).toRegex();
			s = args.get(0).toString(ns);
			m = r.matcher(s);
			if(m.find()) {
				ns.getRoot().assign(
						"RSTART",
						v = AwkInteger.valueOf(m.start() + 1));
				ns.getRoot().assign(
						"RLENGTH",
						AwkInteger.valueOf(m.end() - m.start()));
				return v;
			} else {
				return AwkInteger.ZERO;
			}
		}
	}

}
