/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.io.UnsupportedEncodingException;

import net.morilib.awk.io.AwkVirtualFile;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/26
 */
public class ExtendAwkBTest extends AwkTestCase {

	public void testBAt() {
		eqi("b.at(\"\\x72\\x73\\xa4\", 1)", 0x72);
		eqi("b.at(\"\\x72\\x73\\xa4\", 2)", 0x73);
		eqi("b.at(\"\\x72\\x73\\xff\", 3)", (byte)0xff);
		erz("b.at(\"\\x72\\x73\\xa4\", 0)");
		erz("b.at(\"\\x72\\x73\\xa4\", 4)");
	}

	public void testBUat() {
		eqi("b.uat(\"\\x72\\x73\\xa4\", 1)", 0x72);
		eqi("b.uat(\"\\x72\\x73\\xa4\", 2)", 0x73);
		eqi("b.uat(\"\\x72\\x73\\xa4\", 3)", 0xa4);
		erz("b.uat(\"\\x72\\x73\\xa4\", 0)");
		erz("b.uat(\"\\x72\\x73\\xa4\", 4)");
	}

	public void testBShortat() {
		eqi("b.shortat(\"\\x01\\x02\\x03\", 1, \"big\")", 0x102);
		eqi("b.shortat(\"\\x01\\x02\\x03\", 2, \"big\")", 0x203);
		eqi("b.shortatb(\"\\x01\\x02\\x03\", 1)", 0x102);
		eqi("b.shortat(\"\\x01\\x02\\x03\", 1, \"little\")", 0x201);
		eqi("b.shortat(\"\\x01\\x02\\x03\", 2, \"little\")", 0x302);
		eqi("b.shortatl(\"\\x01\\x02\\x03\", 1)", 0x201);
		eqi("b.shortat(\"\\xff\\xfe\", 1, \"big\")", (short)0xfffe);
		erz("b.shortat(\"\\x01\\x02\\x03\", 0)");
		erz("b.shortat(\"\\x01\\x02\\x03\", 3)");
	}

	public void testBUshortat() {
		eqi("b.ushortat(\"\\x01\\x02\\x03\", 1, \"big\")", 0x102);
		eqi("b.ushortat(\"\\x01\\x02\\x03\", 2, \"big\")", 0x203);
		eqi("b.ushortatb(\"\\x01\\x02\\x03\", 1)", 0x102);
		eqi("b.ushortat(\"\\x01\\x02\\x03\", 1, \"little\")", 0x201);
		eqi("b.ushortat(\"\\x01\\x02\\x03\", 2, \"little\")", 0x302);
		eqi("b.ushortatl(\"\\x01\\x02\\x03\", 1)", 0x201);
		eqi("b.ushortat(\"\\xff\\xfe\", 1, \"big\")", 0xfffe);
		erz("b.ushortat(\"\\x01\\x02\\x03\", 0)");
		erz("b.ushortat(\"\\x01\\x02\\x03\", 3)");
	}

	public void testBIntat() {
		eqi("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 1, \"big\")", 0x1020304);
		eqi("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 2, \"big\")", 0x2030405);
		eqi("b.intatb(\"\\x01\\x02\\x03\\x04\\x05\", 1)", 0x1020304);
		eqi("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 1, \"little\")", 0x4030201);
		eqi("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 2, \"little\")", 0x5040302);
		eqi("b.intatl(\"\\x01\\x02\\x03\\x04\\x05\", 1)", 0x4030201);
		eqi("b.intat(\"\\xff\\xff\\xff\\xfe\", 1, \"big\")", -2);
		erz("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 0)");
		erz("b.intat(\"\\x01\\x02\\x03\\x04\\x05\", 3)");
	}

	public void testBUintat() {
		eqi("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 1, \"big\")", 0x1020304);
		eqi("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 2, \"big\")", 0x2030405);
		eqi("b.uintatb(\"\\x01\\x02\\x03\\x04\\x05\", 1)", 0x1020304);
		eqi("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 1, \"little\")", 0x4030201);
		eqi("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 2, \"little\")", 0x5040302);
		eqi("b.uintatl(\"\\x01\\x02\\x03\\x04\\x05\", 1)", 0x4030201);
		eqi("b.uintat(\"\\xff\\xff\\xff\\xfe\", 1, \"big\")", 0xfffffffel);
		erz("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 0)");
		erz("b.uintat(\"\\x01\\x02\\x03\\x04\\x05\", 3)");
	}

	public void testBLongat() {
		eqi("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 1, \"big\")", 0x102030405060708l);
		eqi("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 2, \"big\")", 0x203040506070809l);
		eqi("b.longatb(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 1)", 0x102030405060708l);
		eqi("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 1, \"little\")", 0x807060504030201l);
		eqi("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 2, \"little\")", 0x908070605040302l);
		eqi("b.longatl(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 1)", 0x807060504030201l);
		eqi("b.longat(\"\\xff\\xff\\xff\\xff\\xff\\xff\\xff\\xfe\", 1, \"big\")", -2);
		erz("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 0)");
		erz("b.longat(\"\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\x08\\x09\", 3)");
	}

	public void testBTostring() {
		eqs("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", \"UTF-8\")", "あい");
		eqs("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 4, \"UTF-8\")", "い");
		eqs("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 7, \"UTF-8\")", "");
		eqs("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 1, 4, \"UTF-8\")", "あ");
		eqs("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 1, 7, \"UTF-8\")", "あい");
		eqs("b.tostring(\"\\x82\\xa0\\x82\\xa0\", \"Shift_JIS\")", "ああ");
		erz("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 0, \"UTF-8\")");
		erz("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 8, \"UTF-8\")");
		erz("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 1, 0, \"UTF-8\")");
		erz("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 1, 8, \"UTF-8\")");
		erz("b.tostring(\"\\xe3\\x81\\x82\\xe3\\x81\\x84\", 4, 1, \"UTF-8\")");
	}

	public void testBC() {
		eqs("b.c(32, 32, 32, 32)", "    ");
	}

	void eqd(String s, String o) {
		eqi(s, 1);
		try {
			assertEquals(AwkVirtualFile.DEBUG_BIN_IO.toString("ISO-8859-1"), o);
			AwkVirtualFile.DEBUG_BIN_IO.reset();
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}

	public void testBWrite() {
		eqd("b.write(\"" + AwkVirtualFile.DEBUG + "\", \"  \")", "  ");
	}

	public void testBWritebyte() {
		eqd("b.writebyte(\"" + AwkVirtualFile.DEBUG + "\", 32, 32)", "  ");
		eqd("b.writebyte(\"" + AwkVirtualFile.DEBUG + "\", 255, -1)", "\u00ff\u00ff");
	}

	public void testBWriteshort() {
		eqd("b.writeshort(\"" + AwkVirtualFile.DEBUG + "\", \"big\", 65534, -2)",
				"\u00ff\u00fe\u00ff\u00fe");
		eqd("b.writeshortb(\"" + AwkVirtualFile.DEBUG + "\", 65534, -2)",
				"\u00ff\u00fe\u00ff\u00fe");
		eqd("b.writeshort(\"" + AwkVirtualFile.DEBUG + "\", \"little\", 65534, -2)",
				"\u00fe\u00ff\u00fe\u00ff");
		eqd("b.writeshortl(\"" + AwkVirtualFile.DEBUG + "\", 65534, -2)",
				"\u00fe\u00ff\u00fe\u00ff");
		eqd("b.writeshort(\"" + AwkVirtualFile.DEBUG + "\", 65534, -2)",
				"\u00fe\u00ff\u00fe\u00ff");
	}

	public void testBWriteint() {
		eqd("b.writeint(\"" + AwkVirtualFile.DEBUG + "\", \"big\", 4294967294, -2)",
				"\u00ff\u00ff\u00ff\u00fe\u00ff\u00ff\u00ff\u00fe");
		eqd("b.writeintb(\"" + AwkVirtualFile.DEBUG + "\", 4294967294, -2)",
				"\u00ff\u00ff\u00ff\u00fe\u00ff\u00ff\u00ff\u00fe");
		eqd("b.writeint(\"" + AwkVirtualFile.DEBUG + "\", \"little\", 4294967294, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00fe\u00ff\u00ff\u00ff");
		eqd("b.writeintl(\"" + AwkVirtualFile.DEBUG + "\", 4294967294, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00fe\u00ff\u00ff\u00ff");
		eqd("b.writeint(\"" + AwkVirtualFile.DEBUG + "\", 4294967294, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00fe\u00ff\u00ff\u00ff");
	}

	public void testBWritelong() {
		eqd("b.writelong(\"" + AwkVirtualFile.DEBUG + "\", \"big\", 18446744073709551614, -2)",
				"\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00fe" +
				"\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00fe");
		eqd("b.writelongb(\"" + AwkVirtualFile.DEBUG + "\", 18446744073709551614, -2)",
				"\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00fe" +
				"\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00fe");
		eqd("b.writelong(\"" + AwkVirtualFile.DEBUG + "\", \"little\", 18446744073709551614, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff" +
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff");
		eqd("b.writelongl(\"" + AwkVirtualFile.DEBUG + "\", 18446744073709551614, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff" +
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff");
		eqd("b.writelong(\"" + AwkVirtualFile.DEBUG + "\", 18446744073709551614, -2)",
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff" +
				"\u00fe\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff");
	}

}
