/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 組み込み関数srandの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkSrand extends AwkUnaryArgs {

	protected AwkSrand() {
		super("srand");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		long s = AwkRand.RANDOM.getSeed();

		if(a1 instanceof AwkUndefined) {
			AwkRand.RANDOM.init(new java.util.Date().getTime());
		} else if(a1.isReal()) {
			AwkRand.RANDOM.init(a1.toInteger().longValue());
		} else {
			AwkRand.RANDOM.init(a1.hashCode());
		}
		return AwkInteger.valueOf(s);
	}

}
