/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.parser.AwkLexer;
import net.morilib.awk.parser.AwkParser;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数util.evalの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class UtilEval extends AwkFunction {

	/**
	 * @param name
	 * @param env
	 */
	protected UtilEval() {
		super("eval", null);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkFunction#apply(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, java.util.List)
	 */
	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		AwkExpression st;
		StringReader sr;
		AwkValue v;
		String s;

		try {
			s  = args.size() < 1 ? "" : args.get(0).toString(ns);
			sr = new StringReader(s);
			st = AwkParser.parseStatement(new AwkLexer(sr));
			st = st.compileInternally();
			v  = st.eval(ns, o);
			return v != null ? v : AwkUndefined.UNDEF;
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

}
