/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

/**
 * byteのソートされた集合です。
 * 
 * @author MORIGUCHI, Yuichiro 2010/10/11
 */
public interface ByteSortedSet extends ByteSet {

	/**
	 * 与えられた集合に含まれない集合を得ます。
	 * 
	 * @param set 集合
	 * @return 差集合
	 */
	public ByteSortedSet collect(ByteSortedSet set);

	/**
	 * 最初の値を得ます。
	 * 
	 * @return 最初の値
	 */
	public byte first();

	/**
	 * -128から与えられた値までの部分を返します。
	 * 
	 * @param v 値
	 * @return 部分集合
	 */
	public ByteSortedSet headSet(byte v);

	/**
	 * [s, e]にある部分集合を得ます。
	 * 
	 * @param s 部分集合開始値
	 * @param e 部分集合終了値
	 * @return 部分集合
	 */
	public ByteSortedSet subSet(byte s, byte e);

	/**
	 * 与えられた値から127までの部分を返します。
	 * 
	 * @param v 値
	 * @return 部分集合
	 */
	public ByteSortedSet tailSet(byte v);

	/**
	 * 最後の値を得ます。
	 * 
	 * @return 最後の値
	 */
	public byte last();

}
