/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.strftime;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;

/**
 * %Eに対応するアクションです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class StrftimeEuAction implements StrftimeAction {

	public void action(Writer writer, Date date) throws IOException {
		writer.append(String.format("%2d",
				StrftimeWareki.LONG.getYear(date)));
	}

}
