/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;

public interface ShFile {

	/**
	 * 
	 * @return
	 */
	public boolean isDirectory();

	/**
	 * 
	 * @return
	 */
	public boolean isExecutable();

	/**
	 * 
	 * @return
	 */
	public boolean isExist();

	/**
	 * 
	 * @return
	 */
	public boolean isFile();

	/**
	 * 
	 * @return
	 */
	public boolean isReadable();

	/**
	 * 
	 * @return
	 */
	public boolean isWritable();

	/**
	 * 
	 * @return
	 */
	public boolean isHidden();

	/**
	 * 
	 * @return
	 */
	public boolean isZeroFile();

	/**
	 * 
	 * @return
	 */
	public long getLastModified();

	/**
	 * 
	 * @return
	 */
	public String getName();

	/**
	 * 
	 * @return
	 */
	public Collection<ShFile> getFiles();

	/**
	 * 
	 * @return
	 */
	public InputStream getInputStream() throws IOException;

	/**
	 * 
	 * @return
	 */
	public PrintStream getPrintStream(
			boolean append) throws IOException;

	/**
	 * 
	 * @return
	 */
	public ShProcess getProcess(String... args);

	/**
	 * 
	 * @return
	 */
	public ShFile toAbsolute();

	/**
	 * 
	 * @return
	 */
	public boolean mkdir();

	/**
	 * 
	 * @param f
	 * @return
	 */
	public boolean renameTo(ShFile f);

	/**
	 * 
	 * @param time
	 */
	public void setLastModified(long time);

	/**
	 * 
	 * @return
	 */
	public boolean rmdir();

	/**
	 * 
	 * @return
	 */
	public boolean deleteFile();

	/**
	 * 
	 * @return
	 */
	public ShStat getStat();

}
