/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;

import net.morilib.sh.misc.XtraceStream;

public class ShKeyword extends ShToken {

	private String value;

	public ShKeyword(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}

	@Override
	public boolean isString() {
		return true;
	}

	@Override
	public boolean equalsKeyword(String keyword) {
		return value.equals(keyword);
	}

	public List<ShToken> replaceBracket() {
		return Collections.<ShToken>singletonList(this);
	}

	public ShToken replaceTilde(ShEnvironment env) {
		return new ShString(ShToken.replaceTilde(env, value));
	}

	@Override
	public List<ShToken> replaceParameter(ShEnvironment env,
			PrintStream err) {
		return Collections.<ShToken>singletonList(this);
	}

	@Override
	public ShToken replaceCommand(ShEnvironment env, ShFileSystem fs,
			ShRuntime run, XtraceStream p) {
		return this;
	}

	@Override
	public ShToken replaceArithmetic(ShEnvironment env) {
		return this;
	}

	@Override
	public List<String> splitWord(String ifs) {
		return Collections.singletonList(value);
	}

	@Override
	public boolean isWildcard() {
		return ShToken.isWildcard(value);
	}

	@Override
	public boolean isBind() {
		return ShToken.isBind(value);
	}

	@Override
	public void bindVariable(ShEnvironment env,
			ShFileSystem fs, ShRuntime run, PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		ShToken.bindVariable(env, fs, run, err, p, value);
	}

	@Override
	public int hashCode() {
		return value.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		return (o instanceof ShKeyword &&
				value.equals(((ShKeyword)o).value));
	}

	@Override
	public String toString() {
		return value;
	}

}
