/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.EnumSet;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/16
 */
public enum ShSignal {

	EXIT(true), DEBUG(false), RETURN(false), IO(true);

	//
	private boolean inherit;

	//
	private ShSignal(boolean inherit) {
		this.inherit = inherit;
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public static ShSignal getInstance(String name) {
		try {
			return Enum.valueOf(ShSignal.class, name);
		} catch(IllegalArgumentException e) {
			return null;
		}
	}

	/**
	 * 
	 * @return
	 */
	public static EnumSet<ShSignal> getAll() {
		return EnumSet.allOf(ShSignal.class);
	}

	/**
	 * 
	 * @return
	 */
	public boolean isInherit() {
		return inherit;
	}

}
