/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeRedirect implements ShTree {

	private List<ShRedirector> types;
	private List<ShToken> files;
	private ShTree line;
	private transient ShTree comp = null;

	/**
	 * 
	 * @param line
	 * @param types
	 * @param files
	 */
	public ShTreeRedirect(ShTree line,
			List<ShRedirector> types,
			List<ShToken> files) {
		this.types = new ArrayList<ShRedirector>(types);
		this.files = new ArrayList<ShToken>(files);
		this.line  = line;
	}

	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream stdin,
			PrintStream stdout,
			PrintStream stderr,
			XtraceStream p) throws IOException, ShSyntaxException {
		InputStream in  = stdin;
		PrintStream[] a;

		a = new PrintStream[] { null, stdout, stderr };
		for(int i = 0; i < types.size(); i++) {
			in = ShFiles.redirect(env, fs, run, types.get(i),
					files.get(i), stdin, a, p);
		}
		if(comp == null)  comp = ShTrees.compile(line);
		return comp.eval(env, fs, cmds, run, in, a[1], a[2], p);
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

	public String toString() {
		StringBuffer b = new StringBuffer();

		b.append(line);
		for(int i = 0; i < types.size(); i++) {
			b.append(' ').append(types.get(i));
			if(files.get(i) != null) {
				b.append(' ').append(files.get(i));
			}
		}
		return b.toString();
	}

}
