/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/26
 */
public class ShExport implements ShProcess {

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShProcess#main(net.morilib.sh.ShEnvironment, net.morilib.sh.ShFileSystem, java.io.InputStream, java.io.PrintStream, java.io.PrintStream, java.lang.String[])
	 */
	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		String s, n;
		int x;

		for(int i = 1; i < args.length; i++) {
			s = args[i];
			if((x = s.indexOf('=')) < 0) {
				env.export(s);
			} else if(x < s.length() - 1) {
				env.export(n = s.substring(0, x));
				if(env.isReadonly(n)) {
					err.print(n);
					err.println(": readonly variable");
				} else {
					env.bind(n, s.substring(x + 1));
				}
			} else {
				env.export(n = s.substring(0, x));
				if(env.isReadonly(n)) {
					err.print(n);
					err.println(": readonly variable");
				} else {
					env.bind(n, "");
				}
			}
		}
		return 0;
	}

}
