/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class ExtendAwkExpressionTest extends AwkTestCase {

	public void testTerm() {
		eqa("a.c(1.0, 2.0) + a.c(3.0, 4.0)", 4.0, 6.0);
		eqa("a.c(1.0, 2.0) - a.c(3.0, 4.0)", -2.0, -2.0);
		eqa("a.c(1.0, 2.0) + a.c(3.0, 4.0, 5.0)", 4.0, 6.0, 5.0);
		eqa("a.c(1.0, 2.0) - a.c(3.0, 4.0, 5.0)", -2.0, -2.0, -5.0);
		eqa("a.c(1.0, 2.0, 5.0) + a.c(3.0, 4.0)", 4.0, 6.0, 5.0);
		eqa("a.c(1.0, 2.0, 5.0) - a.c(3.0, 4.0)", -2.0, -2.0, 5.0);
		eqa("1.0 + a.c(3.0, 4.0, 5.0)", 4.0, 5.0, 6.0);
		eqa("1.0 - a.c(3.0, 4.0, 5.0)", -2.0, -3.0, -4.0);
		eqa("a.c(3.0, 4.0, 5.0) + 1.0", 4.0, 5.0, 6.0);
		eqa("a.c(3.0, 4.0, 5.0) - 1.0", 2.0, 3.0, 4.0);
		eqa("a + a.c(3.0, 4.0, 5.0)", 3.0, 4.0, 5.0);
		eqa("a - a.c(3.0, 4.0, 5.0)", -3.0, -4.0, -5.0);
		eqa("a.c(3.0, 4.0, 5.0) + a", 3.0, 4.0, 5.0);
		eqa("a.c(3.0, 4.0, 5.0) - a", 3.0, 4.0, 5.0);
	}

	public void testFactor() {
		eqa("a.c(1.0, 2.0) * a.c(3.0, 4.0)", 3.0, 8.0);
		eqa("a.c(1.0, 2.0) / a.c(4.0, 4.0)", 0.25, 0.5);
		eqa("a.c(1.0, 2.0) * a.c(3.0, 4.0, 5.0)", 3.0, 8.0, 0.0);
		eqa("a.c(1.0, 2.0) / a.c(4.0, 4.0, 5.0)", 0.25, 0.5, 0.0);
		eqa("a.c(1.0, 2.0, 5.0) * a.c(3.0, 4.0)", 3.0, 8.0, 0.0);
		eqa("a.c(1.0, 2.0, 5.0) / a.c(4.0, 4.0)", 0.25, 0.5, Double.POSITIVE_INFINITY);
		eqa("2.0 * a.c(3.0, 4.0, 5.0)", 6.0, 8.0, 10.0);
		eqa("1.0 / a.c(0.5, 1.0, 2.0)", 2.0, 1.0, 0.5);
		eqa("a.c(3.0, 4.0, 5.0) * 2.0", 6.0, 8.0, 10.0);
		eqa("a.c(2.0, 4.0, 6.0) / 2.0", 1.0, 2.0, 3.0);
		eqa("a * a.c(3.0, 4.0, 5.0)", 0.0, 0.0, 0.0);
		eqa("a / a.c(3.0, 4.0, 5.0)", 0.0, 0.0, 0.0);
		eqa("a.c(3.0, 4.0, 5.0) * a", 0.0, 0.0, 0.0);
		eqa("a.c(3.0, 4.0, 5.0) / a", Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
	}

	public void testPow() {
		eqa("a.c(2.0, 3.0) ^ a.c(2.0, 3.0)", 4.0, 27.0);
		eqa("a.c(2.0, 3.0) ^ a.c(2.0, 3.0, 4.0)", 4.0, 27.0, 0.0);
		eqa("a.c(2.0, 3.0, 5.0) ^ a.c(2.0, 3.0)", 4.0, 27.0, 1.0);
		eqa("2.0 ^ a.c(3.0, 4.0, 5.0)", 8.0, 16.0, 32.0);
		eqa("a.c(3.0, 4.0, 5.0) ^ 2.0", 9.0, 16.0, 25.0);
		eqa("a ^ a.c(3.0, 4.0, 5.0)", 0.0, 0.0, 0.0);
		eqa("a.c(3.0, 4.0, 5.0) ^ a", 1.0, 1.0, 1.0);
	}

	public void testUnaries() {
		eqa("-a.c(2.0, 3.0)", -2.0, -3.0);
	}

	public void testConcat() {
		eqa("a.c(\"2\", \"3\") a.c(\"2\", \"3\")", "22", "33");
		eqa("a.c(\"2\", \"3\") a.c(\"2\", \"3\", \"4\")", "22", "33", "4");
		eqa("a.c(\"2\", \"3\", \"5\") a.c(\"2\", \"3\")", "22", "33", "5");
		eqa("\"2\" a.c(\"3\", \"4\", \"5\")", "23", "24", "25");
		eqa("a.c(\"3\", \"4\", \"5\") \"2\"", "32", "42", "52");
		eqa("a a.c(\"3\", \"4\", \"5\")", "3", "4", "5");
		eqa("a.c(\"3\", \"4\", \"5\") a", "3", "4", "5");
	}

	public void testRelop() {
		eqa("a.c(1.0, 2.0) >  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(1.0, 2.0) >= a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(1.0, 2.0) <  a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(1.0, 2.0) <= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(1.0, 2.0) == a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(1.0, 2.0) != a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(1.0, 4.0) >  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(1.0, 4.0) >= a.c(3.0, 4.0)", 0, 1);
		eqa("a.c(1.0, 4.0) <  a.c(3.0, 4.0)", 1, 0);
		eqa("a.c(1.0, 4.0) <= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(1.0, 4.0) == a.c(3.0, 4.0)", 0, 1);
		eqa("a.c(1.0, 4.0) != a.c(3.0, 4.0)", 1, 0);
		eqa("a.c(3.0, 4.0) >  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(3.0, 4.0) >= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(3.0, 4.0) <  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(3.0, 4.0) <= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(3.0, 4.0) == a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(3.0, 4.0) != a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(5.0, 4.0) >  a.c(3.0, 4.0)", 1, 0);
		eqa("a.c(5.0, 4.0) >= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(5.0, 4.0) <  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(5.0, 4.0) <= a.c(3.0, 4.0)", 0, 1);
		eqa("a.c(5.0, 4.0) == a.c(3.0, 4.0)", 0, 1);
		eqa("a.c(5.0, 4.0) != a.c(3.0, 4.0)", 1, 0);
		eqa("a.c(5.0, 4.5) >  a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(5.0, 4.5) >= a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(5.0, 4.5) <  a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(5.0, 4.5) <= a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(5.0, 4.5) == a.c(3.0, 4.0)", 0, 0);
		eqa("a.c(5.0, 4.5) != a.c(3.0, 4.0)", 1, 1);
		eqa("a.c(1.0, 2.0) >  a.c(0.0, 4.0)", 1, 0);
		eqa("a.c(1.0, 2.0) >= a.c(0.0, 4.0)", 1, 0);
		eqa("a.c(1.0, 2.0) <  a.c(0.0, 4.0)", 0, 1);
		eqa("a.c(1.0, 2.0) <= a.c(0.0, 4.0)", 0, 1);
		eqa("a.c(1.0, 2.0) == a.c(0.0, 4.0)", 0, 0);
		eqa("a.c(1.0, 2.0) != a.c(0.0, 4.0)", 1, 1);

		eqa("a.c(1.0, 2.0, 3.0) >  a.c(0.0, 1.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >= a.c(0.0, 1.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  a.c(0.0, 1.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= a.c(0.0, 1.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) == a.c(0.0, 1.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) != a.c(0.0, 1.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 0.0) >  a.c(0.0, 1.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 0.0) >= a.c(0.0, 1.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 0.0) <  a.c(0.0, 1.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 0.0) <= a.c(0.0, 1.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 0.0) == a.c(0.0, 1.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 0.0) != a.c(0.0, 1.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 0.0) >  a.c(2.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 0.0) >= a.c(2.0, 3.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 0.0) <  a.c(2.0, 3.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 0.0) <= a.c(2.0, 3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 0.0) == a.c(2.0, 3.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 0.0) != a.c(2.0, 3.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0, -1.0) >  a.c(2.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, -1.0) >= a.c(2.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, -1.0) <  a.c(2.0, 3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, -1.0) <= a.c(2.0, 3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0, -1.0) == a.c(2.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0, -1.0) != a.c(2.0, 3.0)", 1, 1, 1);

		eqa("a.c(1.0, 2.0) >  a.c(0.0, 1.0, -3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) >= a.c(0.0, 1.0, -3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) <  a.c(0.0, 1.0, -3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) <= a.c(0.0, 1.0, -3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) == a.c(0.0, 1.0, -3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) != a.c(0.0, 1.0, -3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) >  a.c(0.0, 1.0, 0.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0) >= a.c(0.0, 1.0, 0.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) <  a.c(0.0, 1.0, 0.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) <= a.c(0.0, 1.0, 0.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0) == a.c(0.0, 1.0, 0.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0) != a.c(0.0, 1.0, 0.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0) >  a.c(2.0, 3.0, 0.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) >= a.c(2.0, 3.0, 0.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0) <  a.c(2.0, 3.0, 0.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0) <= a.c(2.0, 3.0, 0.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) == a.c(2.0, 3.0, 0.0)", 0, 0, 1);
		eqa("a.c(1.0, 2.0) != a.c(2.0, 3.0, 0.0)", 1, 1, 0);
		eqa("a.c(1.0, 2.0) >  a.c(2.0, 3.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) >= a.c(2.0, 3.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) <  a.c(2.0, 3.0, 3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) <= a.c(2.0, 3.0, 3.0)", 1, 1, 1);
		eqa("a.c(1.0, 2.0) == a.c(2.0, 3.0, 3.0)", 0, 0, 0);
		eqa("a.c(1.0, 2.0) != a.c(2.0, 3.0, 3.0)", 1, 1, 1);

		eqa("a.c(1.0, 2.0, 3.0) >  0.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >= 0.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  0.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= 0.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) == 0.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) != 0.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >  1.0", 0, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >= 1.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  1.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= 1.0", 1, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) == 1.0", 1, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) != 1.0", 0, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >  2.0", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 3.0) >= 2.0", 0, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  2.0", 1, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= 2.0", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 3.0) == 2.0", 0, 1, 0);
		eqa("a.c(1.0, 2.0, 3.0) != 2.0", 1, 0, 1);
		eqa("a.c(1.0, 2.0, 3.0) >  3.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) >= 3.0", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  3.0", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= 3.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) == 3.0", 0, 0, 1);
		eqa("a.c(1.0, 2.0, 3.0) != 3.0", 1, 1, 0);
		eqa("a.c(1.0, 2.0, 3.0) >  4.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) >= 4.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <  4.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <= 4.0", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) == 4.0", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) != 4.0", 1, 1, 1);
		eqa("a.c(\"1\", \"2\", \"3\") == \"1\"", 1, 0, 0);
		eqa("a.c(\"1\", \"1\", \"1\") == \"1\"", 1, 1, 1);
		eqa("a.c(\"1\", \"2\", \"3\") != \"1\"", 0, 1, 1);
		eqa("a.c(\"1\", \"1\", \"1\") != \"1\"", 0, 0, 0);

		eqa("0.0 >  a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("0.0 >= a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("0.0 <  a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("0.0 <= a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("0.0 == a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("0.0 != a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("0.5 >  a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("0.5 >= a.c(0.5, 1.0, 2.0)", 1, 0, 0);
		eqa("0.5 <  a.c(0.5, 1.0, 2.0)", 0, 1, 1);
		eqa("0.5 <= a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("0.5 == a.c(0.5, 1.0, 2.0)", 1, 0, 0);
		eqa("0.5 != a.c(0.5, 1.0, 2.0)", 0, 1, 1);
		eqa("1.0 >  a.c(0.5, 1.0, 2.0)", 1, 0, 0);
		eqa("1.0 >= a.c(0.5, 1.0, 2.0)", 1, 1, 0);
		eqa("1.0 <  a.c(0.5, 1.0, 2.0)", 0, 0, 1);
		eqa("1.0 <= a.c(0.5, 1.0, 2.0)", 0, 1, 1);
		eqa("1.0 == a.c(0.5, 1.0, 2.0)", 0, 1, 0);
		eqa("1.0 != a.c(0.5, 1.0, 2.0)", 1, 0, 1);
		eqa("2.0 >  a.c(0.5, 1.0, 2.0)", 1, 1, 0);
		eqa("2.0 >= a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("2.0 <  a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("2.0 <= a.c(0.5, 1.0, 2.0)", 0, 0, 1);
		eqa("2.0 == a.c(0.5, 1.0, 2.0)", 0, 0, 1);
		eqa("2.0 != a.c(0.5, 1.0, 2.0)", 1, 1, 0);
		eqa("3.0 >  a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("3.0 >= a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("3.0 <  a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("3.0 <= a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("3.0 == a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("3.0 != a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("\"1\" == a.c(\"1\", \"2\", \"3\")", 1, 0, 0);
		eqa("\"1\" == a.c(\"1\", \"1\", \"1\")", 1, 1, 1);
		eqa("\"1\" != a.c(\"1\", \"2\", \"3\")", 0, 1, 1);
		eqa("\"1\" != a.c(\"1\", \"1\", \"1\")", 0, 0, 0);

		eqa("a.c(1.0, 2.0, 3.0) >  a", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) >= a", 1, 1, 1);
		eqa("a.c(1.0, 2.0, 3.0) <  a", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) <= a", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) == a", 0, 0, 0);
		eqa("a.c(1.0, 2.0, 3.0) != a", 1, 1, 1);
		eqa("a >  a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("a >= a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("a <  a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("a <= a.c(0.5, 1.0, 2.0)", 1, 1, 1);
		eqa("a == a.c(0.5, 1.0, 2.0)", 0, 0, 0);
		eqa("a != a.c(0.5, 1.0, 2.0)", 1, 1, 1);
	}

	public void testAssignop() {
		eqa("a  = a.c(1.0, 2.0)", 1.0, 2.0);
		eqa("a += 3", 4.0, 5.0);
		eqa("a -= 2", 2.0, 3.0);
		eqa("a *= 3", 6.0, 9.0);
		eqa("a /= 2", 3.0, 4.5);
	}

}
