package net.morilib.unix.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import net.morilib.unix.strftime.Strftime;

import junit.framework.TestCase;

public class StrftimeTest extends TestCase {

	static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd");
	static final SimpleDateFormat FTT = new SimpleDateFormat("HH:mm:ss");

	void chk(String f, String s, String t) {
		try {
			assertEquals(t, Strftime.getInstance().format(f, FMT.parse(s)));
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

	void cht(String f, String s, String t) {
		try {
			assertEquals(t, Strftime.getInstance().format(f, FTT.parse(s)));
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

	public void testa() {
		chk("%a", "2013/05/12", "日");
		chk("%a", "2013/05/13", "月");
		chk("%a", "2013/05/14", "火");
		chk("%a", "2013/05/15", "水");
		chk("%a", "2013/05/16", "木");
		chk("%a", "2013/05/17", "金");
		chk("%a", "2013/05/18", "土");
	}

	public void testA() {
		chk("%A", "2013/05/12", "日曜日");
		chk("%A", "2013/05/13", "月曜日");
		chk("%A", "2013/05/14", "火曜日");
		chk("%A", "2013/05/15", "水曜日");
		chk("%A", "2013/05/16", "木曜日");
		chk("%A", "2013/05/17", "金曜日");
		chk("%A", "2013/05/18", "土曜日");
	}

	public void testb() {
		chk("%b", "2012/01/12", "1");
		chk("%b", "2012/02/13", "2");
		chk("%b", "2012/03/14", "3");
		chk("%b", "2012/04/15", "4");
		chk("%b", "2012/05/16", "5");
		chk("%b", "2012/06/17", "6");
		chk("%b", "2012/07/18", "7");
		chk("%b", "2012/08/18", "8");
		chk("%b", "2012/09/18", "9");
		chk("%b", "2012/10/18", "10");
		chk("%b", "2012/11/18", "11");
		chk("%b", "2012/12/18", "12");
	}

	public void testB() {
		chk("%B", "2012/01/12", "1月");
		chk("%B", "2012/02/13", "2月");
		chk("%B", "2012/03/14", "3月");
		chk("%B", "2012/04/15", "4月");
		chk("%B", "2012/05/16", "5月");
		chk("%B", "2012/06/17", "6月");
		chk("%B", "2012/07/18", "7月");
		chk("%B", "2012/08/18", "8月");
		chk("%B", "2012/09/18", "9月");
		chk("%B", "2012/10/18", "10月");
		chk("%B", "2012/11/18", "11月");
		chk("%B", "2012/12/18", "12月");
	}

	public void testd() {
		chk("%d", "2012/01/01", "01");
		chk("%d", "2012/01/12", "12");
		chk("%d", "2012/01/31", "31");
	}

	public void testH() {
		cht("%H", "00:34:56", "00");
		cht("%H", "01:34:56", "01");
		cht("%H", "12:34:56", "12");
		cht("%H", "13:34:56", "13");
		cht("%H", "23:34:56", "23");
	}

	public void testI() {
		cht("%I", "00:34:56", "12");
		cht("%I", "01:34:56", "01");
		cht("%I", "12:34:56", "12");
		cht("%I", "13:34:56", "01");
		cht("%I", "23:34:56", "11");
	}

	public void testj() {
		chk("%j", "2012/01/01", "001");
		chk("%j", "2012/12/31", "366");
		chk("%j", "2011/12/31", "365");
	}

	public void testm() {
		chk("%m", "2012/01/12", "01");
		chk("%m", "2012/02/13", "02");
		chk("%m", "2012/03/14", "03");
		chk("%m", "2012/04/15", "04");
		chk("%m", "2012/05/16", "05");
		chk("%m", "2012/06/17", "06");
		chk("%m", "2012/07/18", "07");
		chk("%m", "2012/08/18", "08");
		chk("%m", "2012/09/18", "09");
		chk("%m", "2012/10/18", "10");
		chk("%m", "2012/11/18", "11");
		chk("%m", "2012/12/18", "12");
	}

	public void testM() {
		cht("%M", "00:01:56", "01");
		cht("%M", "01:34:56", "34");
	}

	public void testp() {
		cht("%p", "00:34:56", "午前");
		cht("%p", "01:34:56", "午前");
		cht("%p", "12:34:56", "午後");
		cht("%p", "13:34:56", "午後");
		cht("%p", "23:34:56", "午後");
	}

	public void testS() {
		cht("%S", "00:01:01", "01");
		cht("%S", "01:34:56", "56");
	}

	public void testU() {
		chk("%U", "2012/01/01", "00");
		chk("%U", "2012/01/06", "00");
		chk("%U", "2012/01/07", "01");
		chk("%U", "2012/12/25", "51");
		chk("%U", "2012/12/31", "52");
		chk("%U", "2013/01/01", "52");

		chk("%U", "2007/01/06", "53");
		chk("%U", "2007/01/07", "00");

		chk("%U", "2013/01/05", "52");
		chk("%U", "2013/01/06", "00");

		chk("%U", "2003/01/04", "52");
		chk("%U", "2003/01/05", "00");

		chk("%U", "2009/01/03", "51");
		chk("%U", "2009/01/04", "00");

		chk("%U", "2010/01/02", "52");
		chk("%U", "2010/01/03", "00");

		chk("%U", "2011/01/01", "52");
		chk("%U", "2011/01/02", "00");
		chk("%U", "2011/01/09", "01");
	}

	public void testw() {
		chk("%w", "2013/05/12", "0");
		chk("%w", "2013/05/13", "1");
		chk("%w", "2013/05/14", "2");
		chk("%w", "2013/05/15", "3");
		chk("%w", "2013/05/16", "4");
		chk("%w", "2013/05/17", "5");
		chk("%w", "2013/05/18", "6");
	}

	public void testW() {
		chk("%W", "2012/01/01", "52");
		chk("%W", "2012/01/02", "00");

		chk("%W", "2007/01/01", "00");
		chk("%W", "2007/01/08", "01");

		chk("%W", "2013/01/06", "52");
		chk("%W", "2013/01/07", "00");

		chk("%W", "2003/01/05", "52");
		chk("%W", "2003/01/06", "00");

		chk("%W", "2009/01/04", "51");
		chk("%W", "2009/01/05", "00");

		chk("%W", "2010/01/03", "52");
		chk("%W", "2010/01/04", "00");

		chk("%W", "2011/01/02", "52");
		chk("%W", "2011/01/03", "00");
	}

	public void testy() {
		chk("%y", "2013/05/12", "13");
	}

	public void testY() {
		chk("%Y", "2013/05/12", "2013");
	}

	public void testPercent() {
		chk("%%", "2013/05/12", "%");
	}

	public void testD() {
		chk("%D", "2013/05/12", "05/12/13");
	}

	public void teste() {
		chk("%e", "2012/01/12", " 1");
		chk("%e", "2012/02/13", " 2");
		chk("%e", "2012/03/14", " 3");
		chk("%e", "2012/04/15", " 4");
		chk("%e", "2012/05/16", " 5");
		chk("%e", "2012/06/17", " 6");
		chk("%e", "2012/07/18", " 7");
		chk("%e", "2012/08/18", " 8");
		chk("%e", "2012/09/18", " 9");
		chk("%e", "2012/10/18", "10");
		chk("%e", "2012/11/18", "11");
		chk("%e", "2012/12/18", "12");
	}

	public void testh() {
		chk("%h", "2012/01/12", "1");
		chk("%h", "2012/02/13", "2");
		chk("%h", "2012/03/14", "3");
		chk("%h", "2012/04/15", "4");
		chk("%h", "2012/05/16", "5");
		chk("%h", "2012/06/17", "6");
		chk("%h", "2012/07/18", "7");
		chk("%h", "2012/08/18", "8");
		chk("%h", "2012/09/18", "9");
		chk("%h", "2012/10/18", "10");
		chk("%h", "2012/11/18", "11");
		chk("%h", "2012/12/18", "12");
	}

	public void testn() {
		chk("%n", "2013/05/12", "\n");
	}

	public void testr() {
		cht("%r", "00:34:56", "12:34:56 午前");
		cht("%r", "01:34:56", "01:34:56 午前");
		cht("%r", "12:34:56", "12:34:56 午後");
		cht("%r", "13:34:56", "01:34:56 午後");
		cht("%r", "23:34:56", "11:34:56 午後");
	}

	public void testR() {
		cht("%R", "00:34:56", "00:34");
		cht("%R", "01:34:56", "01:34");
		cht("%R", "12:34:56", "12:34");
		cht("%R", "13:34:56", "13:34");
		cht("%R", "23:34:56", "23:34");
	}

	public void testT() {
		cht("%T", "00:34:56", "00:34:56");
		cht("%T", "01:34:56", "01:34:56");
		cht("%T", "12:34:56", "12:34:56");
		cht("%T", "13:34:56", "13:34:56");
		cht("%T", "23:34:56", "23:34:56");
	}

	public void testt() {
		chk("%t", "2013/05/12", "\t");
	}

	public void testk() {
		cht("%k", "00:34:56", " 0");
		cht("%k", "01:34:56", " 1");
		cht("%k", "12:34:56", "12");
		cht("%k", "13:34:56", "13");
		cht("%k", "23:34:56", "23");
	}

	public void testl() {
		cht("%l", "00:34:56", "12");
		cht("%l", "01:34:56", " 1");
		cht("%l", "12:34:56", "12");
		cht("%l", "13:34:56", " 1");
		cht("%l", "23:34:56", "11");
	}

	public void testC() {
		chk("%C", "2013/05/12", "13");
	}

	public void testu() {
		chk("%u", "2013/05/12", "7");
		chk("%u", "2013/05/13", "1");
		chk("%u", "2013/05/14", "2");
		chk("%u", "2013/05/15", "3");
		chk("%u", "2013/05/16", "4");
		chk("%u", "2013/05/17", "5");
		chk("%u", "2013/05/18", "6");
	}

	public void testv() {
		chk("%v", "2013/05/12", "12-MAY-2013");
	}

	public void testz() {
		chk("%z", "2013/05/12", "+0900");
	}

	public void testCombine() {
		chk("%Y/%m/%d", "2013/05/11", "2013/05/11");
	}

	public void testf() {
		chk("%f", "2013/05/12", "H");
		chk("%f", "1989/01/08", "H");
		chk("%f", "1989/01/07", "S");
		chk("%f", "1926/12/25", "S");
		chk("%f", "1926/12/24", "T");
		chk("%f", "1912/07/30", "T");
		chk("%f", "1912/07/29", "M");
		chk("%f", "1868/10/23", "M");
		chk("%f", "1868/10/22", "?");
	}

	public void testF() {
		chk("%F", "2013/05/12", "平成");
		chk("%F", "1989/01/08", "平成");
		chk("%F", "1989/01/07", "昭和");
		chk("%F", "1926/12/25", "昭和");
		chk("%F", "1926/12/24", "大正");
		chk("%F", "1912/07/30", "大正");
		chk("%F", "1912/07/29", "明治");
		chk("%F", "1868/10/23", "明治");
		chk("%F", "1868/10/22", "明治以前");
	}

	public void testE() {
		chk("%E", "2013/05/12", "25");
		chk("%E", "1989/01/08", " 1");
		chk("%E", "1989/01/07", "64");
		chk("%E", "1926/12/25", " 1");
		chk("%E", "1926/12/24", "15");
		chk("%E", "1912/07/30", " 1");
		chk("%E", "1912/07/29", "45");
		chk("%E", "1868/10/23", " 1");
		chk("%E", "1868/10/22", " 0");
	}

}
