/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.util.regex.Pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkValue;

public class AwkMatcher extends AwkExpression {

	private AwkExpression e1, e2;

	public AwkMatcher(AwkExpression e1, AwkExpression e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue r1 = e1.eval(ns, o), r2 = e2.eval(ns, o);
		Pattern p;
		String s;
		int c;

		if(!r1.isRegex())  throw new AwkCastException();
		p = r1.toRegex();
		s = r2.toString();
		for(int i = 0; i < s.length(); i += c > 0xffff ? 2 : 1) {
			c = s.codePointAt(i);
			if(p.matcher(s.substring(i)).lookingAt()) {
				return AwkValue.TRUE;
			}
		}
		return AwkValue.FALSE;
	}

}
