/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkReferField extends AwkExpression {

	private BigInteger MI = BigInteger.valueOf(Integer.MAX_VALUE);

	private AwkExpression field;

	public AwkReferField(AwkExpression field) {
		this.field = field;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		BigInteger b = field.eval(ns, o).toInteger();

		if(b.compareTo(MI) > 0) {
			return AwkUndefined.UNDEF;
		}
		return ns.referField(b.intValue());
	}

}
