/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.namespace;

import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/08
 */
public class AwkClosureNamespace extends AwkSimpleNamespace {

	/**
	 * @param root
	 */
	public AwkClosureNamespace(AwkNamespace root) {
		super(root);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.AwkSimpleNamespace#find(java.lang.String)
	 */
	@Override
	public AwkValue find(String s) {
		AwkValue v = super.find(s);

		return v != null ? v : root.find(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.AwkSimpleNamespace#findFunction(java.lang.String)
	 */
	@Override
	public AwkFunction findFunction(String s) {
		AwkFunction v = super.findFunction(s);

		return v != null ? v : root.findFunction(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.AwkSimpleNamespace#isReadonly(java.lang.String)
	 */
	@Override
	public boolean isReadonly(String s) {
		return root.isReadonly(s);
	}

}
