/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.namespace;

import java.util.HashMap;
import java.util.Map;

import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

public class AwkSimpleNamespace implements AwkNamespace {

	/**
	 * 
	 */
	protected AwkNamespace root;

	private Map<String, AwkValue> values;
	private Map<String, AwkFunction> functions;
	private Map<String, AwkNamespace> namespaces;

	//
	AwkSimpleNamespace() {
		values = new HashMap<String, AwkValue>();
		functions = new HashMap<String, AwkFunction>();
		namespaces = new HashMap<String, AwkNamespace>();
		this.root = null;
	}

	/**
	 * 
	 */
	public AwkSimpleNamespace(AwkNamespace root) {
		this();
		this.root = root;
	}

	public void assign(String s, AwkValue v) {
		values.put(s, v);
	}

	public AwkValue find(String s) {
		return values.get(s);
	}

	public AwkFunction findFunction(String s) {
		return functions.get(s);
	}

	public void bindFunction(String s, AwkFunction v) {
		functions.put(s, v);
	}

	public boolean isReadonly(String s) {
		return false;
	}

	public synchronized AwkNamespace subnamespace(String s) {
		AwkNamespace ns;

		if((ns = namespaces.get(s)) == null) {
			ns = new AwkSimpleNamespace(this);
			namespaces.put(s, ns);
		}
		return ns;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.namespace.AwkNamespace#referNamespace(java.lang.String)
	 */
	public AwkNamespace referNamespace(String s) {
		return namespaces.get(s);
	}

	public AwkValue referField(int n) {
		return root.referField(n);
	}

	public int sizeOfField() {
		return root.sizeOfField();
	}

	public void setField(String s) {
		root.setField(s);
	}

	public String getFS() {
		return root.getFS();
	}

	public String getRS() {
		return root.getRS();
	}

	public String getOFS() {
		return root.getOFS();
	}

	public String getORS() {
		return root.getORS();
	}

}
