/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

public class AwkOperator extends AwkToken
implements Comparable<AwkOperator> {

	public static final AwkOperator ADD = new AwkOperator("+", 24);
	public static final AwkOperator SUB = new AwkOperator("-", 24);
	public static final AwkOperator MUL = new AwkOperator("*", 22);
	public static final AwkOperator DIV = new AwkOperator("/", 22);
	public static final AwkOperator MOD = new AwkOperator("%", 22);
	public static final AwkOperator POW = new AwkOperator("^", 16);
//	public static final AwkOperator B_AND = new AwkOperator("&");
//	public static final AwkOperator B_OR  = new AwkOperator("|");
	public static final AwkOperator L_AND = new AwkOperator("&&", 36);
	public static final AwkOperator L_OR  = new AwkOperator("||", 38);
	public static final AwkOperator L_NOT = new AwkOperator("!", 20);
	public static final AwkOperator TRI1 = new AwkOperator("?", 40);
	public static final AwkOperator TRI2 = new AwkOperator(":", 40);
	public static final AwkOperator LPAREN = new AwkOperator("(", 1);
	public static final AwkOperator RPAREN = new AwkOperator(")", 1);
	public static final AwkOperator INC = new AwkOperator("++", 18);
	public static final AwkOperator DEC = new AwkOperator("--", 18);
	public static final AwkOperator MATCH = new AwkOperator("~", 32);
	public static final AwkOperator NMATCH = new AwkOperator("!~", 32);
	public static final AwkOperator FIELD = new AwkOperator("$", 12);
	public static final AwkOperator NAME = new AwkOperator(".", 12);
	public static final AwkOperator COMMA = new AwkOperator(",", 99);
	public static final AwkOperator LBRAKET = new AwkOperator("[", 7);
	public static final AwkOperator RBRAKET = new AwkOperator("]", 7);
	public static final AwkOperator REFFN = new AwkOperator("@", 9);

	private int pr;

	AwkOperator(String desc, int priority) {
		super(desc);
		pr = priority;
	}

	public int compareTo(AwkOperator o) {
		return pr > o.pr ? -1 : pr < o.pr ? 1 : 0;
	}

}
