/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.statement;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkValue;

public class AwkReturn extends AwkExpression {

	private AwkExpression expr;

	/**
	 * 
	 * @param expr
	 */
	public AwkReturn(AwkExpression expr) {
		this.expr = expr;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		throw new AwkReturnException(expr.eval(ns, o));
	}

}
